/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text;

import cfca.com.itextpdf.text.Chunk;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.text.ElementListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Meta
implements Element {
    private final int type;
    private final StringBuffer content;
    public static final String UNKNOWN = "unknown";
    public static final String PRODUCER = "producer";
    public static final String CREATIONDATE = "creationdate";
    public static final String AUTHOR = "author";
    public static final String KEYWORDS = "keywords";
    public static final String SUBJECT = "subject";
    public static final String TITLE = "title";

    Meta(int type, String content) {
        this.type = type;
        this.content = new StringBuffer(content);
    }

    public Meta(String tag, String content) {
        this.type = Meta.getType(tag);
        this.content = new StringBuffer(content);
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>();
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public String getContent() {
        return this.content.toString();
    }

    public String getName() {
        switch (this.type) {
            case 2: {
                return SUBJECT;
            }
            case 3: {
                return KEYWORDS;
            }
            case 4: {
                return AUTHOR;
            }
            case 1: {
                return TITLE;
            }
            case 5: {
                return PRODUCER;
            }
            case 6: {
                return CREATIONDATE;
            }
        }
        return UNKNOWN;
    }

    public static int getType(String tag) {
        if (SUBJECT.equals(tag)) {
            return 2;
        }
        if (KEYWORDS.equals(tag)) {
            return 3;
        }
        if (AUTHOR.equals(tag)) {
            return 4;
        }
        if (TITLE.equals(tag)) {
            return 1;
        }
        if (PRODUCER.equals(tag)) {
            return 5;
        }
        if (CREATIONDATE.equals(tag)) {
            return 6;
        }
        return 0;
    }
}

