/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.crypto.securityhandler;

import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.crypto.AESCipherCBCnoPad;
import cfca.sadk.com.itextpdf.kernel.crypto.AesDecryptor;
import cfca.sadk.com.itextpdf.kernel.crypto.BadPasswordException;
import cfca.sadk.com.itextpdf.kernel.crypto.IDecryptor;
import cfca.sadk.com.itextpdf.kernel.crypto.IVGenerator;
import cfca.sadk.com.itextpdf.kernel.crypto.OutputStreamAesEncryption;
import cfca.sadk.com.itextpdf.kernel.crypto.OutputStreamEncryption;
import cfca.sadk.com.itextpdf.kernel.crypto.securityhandler.StandardSecurityHandler;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfLiteral;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import java.io.OutputStream;
import java.security.MessageDigest;

public class StandardHandlerUsingAes256
extends StandardSecurityHandler {
    private static final int VALIDATION_SALT_OFFSET = 32;
    private static final int KEY_SALT_OFFSET = 40;
    private static final int SALT_LENGTH = 8;
    private static final int OU_LENGTH = 48;
    private static final long serialVersionUID = -8365943606887257386L;
    protected boolean encryptMetadata;

    public StandardHandlerUsingAes256(PdfDictionary encryptionDictionary, byte[] userPassword, byte[] ownerPassword, int permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        this.initKeyAndFillDictionary(encryptionDictionary, userPassword, ownerPassword, permissions, encryptMetadata, embeddedFilesOnly);
    }

    public StandardHandlerUsingAes256(PdfDictionary encryptionDictionary, byte[] password) {
        this.initKeyAndReadDictionary(encryptionDictionary, password);
    }

    public boolean isEncryptMetadata() {
        return this.encryptMetadata;
    }

    @Override
    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
    }

    @Override
    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        return new OutputStreamAesEncryption(os, this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    public IDecryptor getDecryptor() {
        return new AesDecryptor(this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    private void initKeyAndFillDictionary(PdfDictionary encryptionDictionary, byte[] userPassword, byte[] ownerPassword, int permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        ownerPassword = this.generateOwnerPasswordIfNullOrEmpty(ownerPassword);
        permissions |= 0xFFFFF0C0;
        permissions &= 0xFFFFFFFC;
        try {
            if (userPassword == null) {
                userPassword = new byte[]{};
            }
            byte[] uvs = IVGenerator.getIV(8);
            byte[] uks = IVGenerator.getIV(8);
            this.nextObjectKey = IVGenerator.getIV(32);
            this.nextObjectKeySize = 32;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(userPassword, 0, Math.min(userPassword.length, 127));
            md.update(uvs);
            byte[] userKey = new byte[48];
            md.digest(userKey, 0, 32);
            System.arraycopy(uvs, 0, userKey, 32, 8);
            System.arraycopy(uks, 0, userKey, 40, 8);
            md.update(userPassword, 0, Math.min(userPassword.length, 127));
            md.update(uks);
            AESCipherCBCnoPad ac = new AESCipherCBCnoPad(true, md.digest());
            byte[] ueKey = ac.processBlock(this.nextObjectKey, 0, this.nextObjectKey.length);
            byte[] ovs = IVGenerator.getIV(8);
            byte[] oks = IVGenerator.getIV(8);
            md.update(ownerPassword, 0, Math.min(ownerPassword.length, 127));
            md.update(ovs);
            md.update(userKey);
            byte[] ownerKey = new byte[48];
            md.digest(ownerKey, 0, 32);
            System.arraycopy(ovs, 0, ownerKey, 32, 8);
            System.arraycopy(oks, 0, ownerKey, 40, 8);
            md.update(ownerPassword, 0, Math.min(ownerPassword.length, 127));
            md.update(oks);
            md.update(userKey);
            ac = new AESCipherCBCnoPad(true, md.digest());
            byte[] oeKey = ac.processBlock(this.nextObjectKey, 0, this.nextObjectKey.length);
            byte[] permsp = IVGenerator.getIV(16);
            permsp[0] = (byte)permissions;
            permsp[1] = (byte)(permissions >> 8);
            permsp[2] = (byte)(permissions >> 16);
            permsp[3] = (byte)(permissions >> 24);
            permsp[4] = -1;
            permsp[5] = -1;
            permsp[6] = -1;
            permsp[7] = -1;
            permsp[8] = encryptMetadata ? 84 : 70;
            permsp[9] = 97;
            permsp[10] = 100;
            permsp[11] = 98;
            ac = new AESCipherCBCnoPad(true, this.nextObjectKey);
            byte[] aes256Perms = ac.processBlock(permsp, 0, permsp.length);
            this.permissions = permissions;
            this.encryptMetadata = encryptMetadata;
            this.setStandardHandlerDicEntries(encryptionDictionary, userKey, ownerKey);
            this.setAES256DicEntries(encryptionDictionary, oeKey, ueKey, aes256Perms, encryptMetadata, embeddedFilesOnly);
        }
        catch (Exception ex) {
            throw new PdfException("PdfEncryption exception.", ex);
        }
    }

    private void setAES256DicEntries(PdfDictionary encryptionDictionary, byte[] oeKey, byte[] ueKey, byte[] aes256Perms, boolean encryptMetadata, boolean embeddedFilesOnly) {
        int aes256Revision = 5;
        encryptionDictionary.put(PdfName.OE, new PdfLiteral(StreamUtil.createEscapedString(oeKey)));
        encryptionDictionary.put(PdfName.UE, new PdfLiteral(StreamUtil.createEscapedString(ueKey)));
        encryptionDictionary.put(PdfName.Perms, new PdfLiteral(StreamUtil.createEscapedString(aes256Perms)));
        encryptionDictionary.put(PdfName.R, new PdfNumber(aes256Revision));
        encryptionDictionary.put(PdfName.V, new PdfNumber(aes256Revision));
        PdfDictionary stdcf = new PdfDictionary();
        stdcf.put(PdfName.Length, new PdfNumber(32));
        if (!encryptMetadata) {
            encryptionDictionary.put(PdfName.EncryptMetadata, PdfBoolean.FALSE);
        }
        if (embeddedFilesOnly) {
            stdcf.put(PdfName.AuthEvent, PdfName.EFOpen);
            encryptionDictionary.put(PdfName.EFF, PdfName.StdCF);
            encryptionDictionary.put(PdfName.StrF, PdfName.Identity);
            encryptionDictionary.put(PdfName.StmF, PdfName.Identity);
        } else {
            stdcf.put(PdfName.AuthEvent, PdfName.DocOpen);
            encryptionDictionary.put(PdfName.StrF, PdfName.StdCF);
            encryptionDictionary.put(PdfName.StmF, PdfName.StdCF);
        }
        stdcf.put(PdfName.CFM, PdfName.AESV3);
        PdfDictionary cf = new PdfDictionary();
        cf.put(PdfName.StdCF, stdcf);
        encryptionDictionary.put(PdfName.CF, cf);
    }

    private void initKeyAndReadDictionary(PdfDictionary encryptionDictionary, byte[] password) {
        try {
            AESCipherCBCnoPad ac;
            if (password == null) {
                password = new byte[]{};
            }
            byte[] oValue = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.O));
            byte[] uValue = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.U));
            byte[] oeValue = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.OE));
            byte[] ueValue = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.UE));
            byte[] perms = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.Perms));
            PdfNumber pValue = (PdfNumber)encryptionDictionary.get(PdfName.P);
            this.permissions = pValue.longValue();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password, 0, Math.min(password.length, 127));
            md.update(oValue, 32, 8);
            md.update(uValue, 0, 48);
            byte[] hash = md.digest();
            this.usedOwnerPassword = StandardHandlerUsingAes256.compareArray(hash, oValue, 32);
            if (this.usedOwnerPassword) {
                md.update(password, 0, Math.min(password.length, 127));
                md.update(oValue, 40, 8);
                md.update(uValue, 0, 48);
                hash = md.digest();
                ac = new AESCipherCBCnoPad(false, hash);
                this.nextObjectKey = ac.processBlock(oeValue, 0, oeValue.length);
            } else {
                md.update(password, 0, Math.min(password.length, 127));
                md.update(uValue, 32, 8);
                hash = md.digest();
                if (!StandardHandlerUsingAes256.compareArray(hash, uValue, 32)) {
                    throw new BadPasswordException("Bad user password. Password is not provided or wrong password provided. Correct password should be passed to PdfReader constructor with properties. See ReaderProperties#setPassword() method.");
                }
                md.update(password, 0, Math.min(password.length, 127));
                md.update(uValue, 40, 8);
                hash = md.digest();
                ac = new AESCipherCBCnoPad(false, hash);
                this.nextObjectKey = ac.processBlock(ueValue, 0, ueValue.length);
            }
            this.nextObjectKeySize = 32;
            ac = new AESCipherCBCnoPad(false, this.nextObjectKey);
            byte[] decPerms = ac.processBlock(perms, 0, perms.length);
            if (decPerms[9] != 97 || decPerms[10] != 100 || decPerms[11] != 98) {
                throw new BadPasswordException("Bad user password. Password is not provided or wrong password provided. Correct password should be passed to PdfReader constructor with properties. See ReaderProperties#setPassword() method.");
            }
            this.permissions = decPerms[0] & 0xFF | (decPerms[1] & 0xFF) << 8 | (decPerms[2] & 0xFF) << 16 | (decPerms[2] & 0xFF) << 24;
            this.encryptMetadata = decPerms[8] == 84;
        }
        catch (BadPasswordException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PdfException("PdfEncryption exception.", ex);
        }
    }

    private static boolean compareArray(byte[] a, byte[] b, int len) {
        for (int k = 0; k < len; ++k) {
            if (a[k] == b[k]) continue;
            return false;
        }
        return true;
    }
}

