/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.CompressionMethod;
import cfca.sadk.tls.sun.security.ssl.CompressionMethods;
import cfca.sadk.tls.sun.security.ssl.EngineOutputRecord;
import cfca.sadk.tls.sun.security.ssl.OutputRecord;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSocketImpl;
import cfca.sadk.tls.sun.security.ssl.SessionId;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtensions;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import java.io.IOException;
import java.io.OutputStream;

public final class HandshakeOutStream
extends OutputStream {
    private SSLSocketImpl socket;
    private SSLEngineImpl engine;
    OutputRecord record;

    HandshakeOutStream(ProtocolVersion protocolVersion, ProtocolVersion helloVersion, HandshakeHash handshakeHash, SSLSocketImpl socket) {
        this.socket = socket;
        this.record = new OutputRecord(22);
        this.init(protocolVersion, helloVersion, handshakeHash);
        this.socket.getAppInputStream().record.setHandshakeHash(handshakeHash);
        this.socket.getAppInputStream().record.setHelloVersion(helloVersion);
        this.socket.getAppOutputStream().record.setHelloVersion(helloVersion);
    }

    HandshakeOutStream(ProtocolVersion protocolVersion, ProtocolVersion helloVersion, HandshakeHash handshakeHash, SSLEngineImpl engine) {
        this.engine = engine;
        this.record = new EngineOutputRecord(22, engine);
        this.init(protocolVersion, helloVersion, handshakeHash);
        this.engine.inputRecord.setHandshakeHash(handshakeHash);
        this.engine.inputRecord.setHelloVersion(helloVersion);
        this.engine.outputRecord.setHelloVersion(helloVersion);
    }

    private void init(ProtocolVersion protocolVersion, ProtocolVersion helloVersion, HandshakeHash handshakeHash) {
        this.record.setVersion(protocolVersion);
        this.record.setHelloVersion(helloVersion);
        this.record.setHandshakeHash(handshakeHash);
    }

    void doHashes() {
        this.record.doHashes();
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        int howmuch = 0;
        while (len > 0) {
            howmuch = Math.min(len, this.record.availableDataBytes());
            if (howmuch == 0) {
                this.flush();
                continue;
            }
            this.record.write(buf, off, howmuch);
            off += howmuch;
            len -= howmuch;
        }
    }

    @Override
    public void write(int i) throws IOException {
        if (this.record.availableDataBytes() < 1) {
            this.flush();
        }
        this.record.write(i);
    }

    @Override
    public void flush() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.writeRecord(this.record);
            }
            catch (IOException e) {
                this.socket.waitForClose(true);
                throw e;
            }
        } else {
            this.engine.writeRecord((EngineOutputRecord)this.record);
        }
    }

    final void setFinishedMsg() {
        assert (this.socket == null);
        ((EngineOutputRecord)this.record).setFinishedMsg();
    }

    public final void putInt8(int i) throws IOException {
        this.checkOverflow(i, 256);
        this.record.write(i);
    }

    public final void putInt16(int i) throws IOException {
        this.checkOverflow(i, 65536);
        if (this.record.availableDataBytes() < 2) {
            this.flush();
        }
        this.record.write(i >> 8);
        this.record.write(i);
    }

    public final void putInt24(int i) throws IOException {
        this.checkOverflow(i, 0x1000000);
        if (this.record.availableDataBytes() < 3) {
            this.flush();
        }
        this.record.write(i >> 16);
        this.record.write(i >> 8);
        this.record.write(i);
    }

    public final void putInt32(int i) throws IOException {
        if (this.record.availableDataBytes() < 4) {
            this.flush();
        }
        this.record.write(i >> 24);
        this.record.write(i >> 16);
        this.record.write(i >> 8);
        this.record.write(i);
    }

    public final void putBytes8(byte[] b) throws IOException {
        if (b == null) {
            this.putInt8(0);
            return;
        }
        this.checkOverflow(b.length, 256);
        this.putInt8(b.length);
        this.write(b, 0, b.length);
    }

    public final void putBytes16(byte[] b) throws IOException {
        if (b == null) {
            this.putInt16(0);
            return;
        }
        this.checkOverflow(b.length, 65536);
        this.putInt16(b.length);
        this.write(b, 0, b.length);
    }

    public final void putBytes24(byte[] b) throws IOException {
        if (b == null) {
            this.putInt24(0);
            return;
        }
        this.checkOverflow(b.length, 0x1000000);
        this.putInt24(b.length);
        this.write(b, 0, b.length);
    }

    public final void putOpaque(ProtocolVersion version) throws IOException {
        this.putInt16(version.version);
    }

    public final void putOpaque(SessionId sessionId) throws IOException {
        this.putBytes8(sessionId.getId());
    }

    public final void putOpaque(CipherSuiteList cipher_suites) throws IOException {
        this.putBytes16(cipher_suites.getEncoded());
    }

    public final void putOpaque(CipherSuite cipherSuite) throws IOException {
        this.putInt16(cipherSuite.id);
    }

    public final void putOpaque(RandomCookie random) throws IOException {
        this.write(random.random, 0, 32);
    }

    public final void putOpaque(HelloExtensions extensions) throws IOException {
        this.write(extensions.getEncoded());
    }

    public void putOpaque(CompressionMethod compression_method) throws IOException {
        this.putInt8(compression_method.value);
    }

    public void putOpaque(CompressionMethods compression_methods) throws IOException {
        this.putBytes8(compression_methods.value);
    }

    private final void checkOverflow(int length, int overflow) {
        if (length >= overflow) {
            throw new RuntimeException("Field length overflow, the field length (" + length + ") should be less than " + overflow);
        }
    }
}

