/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.border;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.layout.border.Border;

public class FixedBorder
extends Border {
    public FixedBorder(float width) {
        super(width);
    }

    public FixedBorder(Color color, float width) {
        super(color, width);
    }

    public FixedBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        canvas.saveState();
        PdfExtGState gs = new PdfExtGState();
        gs.setStrokeOpacity(this.transparentColor.getOpacity());
        canvas.setExtGState(gs);
        canvas.setStrokeColor(this.transparentColor.getColor());
        FixedBorder.drawBorder(canvas, 2.0f, new Rectangle(0.0f, 0.0f, x2 + x1, y2 + y1));
        canvas.restoreState();
    }

    private static void drawBorder(PdfCanvas canvas, float lineWidth, Rectangle rect) {
        float x = rect.getX();
        float y = rect.getY();
        float width = rect.getWidth();
        float height = rect.getHeight();
        float halfLineWidth = lineWidth / 2.0f;
        FixedBorder.drawLine(canvas, lineWidth, x, halfLineWidth, x + width, halfLineWidth);
        FixedBorder.drawLine(canvas, lineWidth, x + width - halfLineWidth, lineWidth, x + width - halfLineWidth, height - lineWidth);
        FixedBorder.drawLine(canvas, lineWidth, x + width, height - halfLineWidth, x + lineWidth, height - halfLineWidth);
        FixedBorder.drawLine(canvas, lineWidth, x + halfLineWidth, height, x + halfLineWidth, y + lineWidth);
    }

    private static void drawLine(PdfCanvas canvas, float lineWidth, float x1, float y1, float x2, float y2) {
        canvas.setLineWidth(lineWidth).moveTo(x1, y1).lineTo(x2, y2).stroke();
    }

    @Override
    public void draw(PdfCanvas arg0, float arg1, float arg2, float arg3, float arg4, float arg5, Border.Side arg6, float arg7, float arg8) {
    }

    @Override
    public void drawCellBorder(PdfCanvas arg0, float arg1, float arg2, float arg3, float arg4) {
    }
}

