/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.annot;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;

public class Pdf3DAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = 3823509772499230844L;

    public Pdf3DAnnotation(Rectangle rect, PdfObject artwork) {
        super(rect);
        this.put(PdfName._3DD, artwork);
    }

    public Pdf3DAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName._3D;
    }

    public Pdf3DAnnotation setDefaultInitialView(PdfObject initialView) {
        return (Pdf3DAnnotation)this.put(PdfName._3DV, initialView);
    }

    public PdfObject getDefaultInitialView() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName._3DV);
    }

    public Pdf3DAnnotation setActivationDictionary(PdfDictionary activationDictionary) {
        return (Pdf3DAnnotation)this.put(PdfName._3DA, activationDictionary);
    }

    public PdfDictionary getActivationDictionary() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName._3DA);
    }

    public Pdf3DAnnotation setInteractive(boolean interactive) {
        return (Pdf3DAnnotation)this.put(PdfName._3DI, PdfBoolean.valueOf(interactive));
    }

    public PdfBoolean isInteractive() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName._3DI);
    }

    public Pdf3DAnnotation setViewBox(Rectangle viewBox) {
        return (Pdf3DAnnotation)this.put(PdfName._3DB, new PdfArray(viewBox));
    }

    public Rectangle getViewBox() {
        return ((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName._3DB);
    }
}

