/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfResources;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.PdfCanvasProcessor;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;

public class PdfKeywordCanvasProcessor
extends PdfCanvasProcessor {
    private IEventListener eventListener = null;

    public PdfKeywordCanvasProcessor(IEventListener eventListener) {
        super(eventListener);
        this.eventListener = eventListener;
    }

    @Override
    public void processPageContent(PdfPage page) {
        byte[] contentBytes = page.getContentBytes();
        PdfResources resources = page.getResources();
        String methodName = MethodCostTimeUtil.recordStartTime("keyword processPageContent");
        this.processContent(contentBytes, resources);
        MethodCostTimeUtil.recordEndTime(methodName);
    }

    @Override
    protected void populateOperators() {
        this.registerContentOperator("DefaultOperator", new PdfCanvasProcessor.IgnoreOperator());
        this.registerContentOperator("q", new PdfCanvasProcessor.PushGraphicsStateOperator());
        this.registerContentOperator("Q", new PdfCanvasProcessor.PopGraphicsStateOperator());
        this.registerContentOperator("cm", new PdfCanvasProcessor.ModifyCurrentTransformationMatrixOperator());
        this.registerContentOperator("Do", new PdfCanvasProcessor.DoOperator());
        this.registerContentOperator("BMC", new PdfCanvasProcessor.BeginMarkedContentOperator());
        this.registerContentOperator("BDC", new PdfCanvasProcessor.BeginMarkedContentDictionaryOperator());
        this.registerContentOperator("EMC", new PdfCanvasProcessor.EndMarkedContentOperator());
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_TEXT) || this.supportedEvents.contains((Object)EventType.BEGIN_TEXT) || this.supportedEvents.contains((Object)EventType.END_TEXT)) {
            this.registerContentOperator("BT", new PdfCanvasProcessor.BeginTextOperator());
            this.registerContentOperator("ET", new PdfCanvasProcessor.EndTextOperator());
        }
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_TEXT)) {
            PdfCanvasProcessor.SetTextCharacterSpacingOperator tcOperator = new PdfCanvasProcessor.SetTextCharacterSpacingOperator();
            this.registerContentOperator("Tc", tcOperator);
            PdfCanvasProcessor.SetTextWordSpacingOperator twOperator = new PdfCanvasProcessor.SetTextWordSpacingOperator();
            this.registerContentOperator("Tw", twOperator);
            this.registerContentOperator("Tz", new PdfCanvasProcessor.SetTextHorizontalScalingOperator());
            PdfCanvasProcessor.SetTextLeadingOperator tlOperator = new PdfCanvasProcessor.SetTextLeadingOperator();
            this.registerContentOperator("TL", tlOperator);
            this.registerContentOperator("Tf", new PdfCanvasProcessor.SetTextFontOperator());
            this.registerContentOperator("Tr", new PdfCanvasProcessor.SetTextRenderModeOperator());
            this.registerContentOperator("Ts", new PdfCanvasProcessor.SetTextRiseOperator());
            PdfCanvasProcessor.TextMoveStartNextLineOperator tdOperator = new PdfCanvasProcessor.TextMoveStartNextLineOperator();
            this.registerContentOperator("Td", tdOperator);
            this.registerContentOperator("TD", new PdfCanvasProcessor.TextMoveStartNextLineWithLeadingOperator(tdOperator, tlOperator));
            this.registerContentOperator("Tm", new PdfCanvasProcessor.TextSetTextMatrixOperator());
            PdfCanvasProcessor.TextMoveNextLineOperator tstarOperator = new PdfCanvasProcessor.TextMoveNextLineOperator(tdOperator);
            this.registerContentOperator("T*", tstarOperator);
            PdfCanvasProcessor.ShowTextOperator tjOperator = new PdfCanvasProcessor.ShowTextOperator();
            this.registerContentOperator("Tj", tjOperator);
            PdfCanvasProcessor.MoveNextLineAndShowTextOperator tickOperator = new PdfCanvasProcessor.MoveNextLineAndShowTextOperator(tstarOperator, tjOperator);
            this.registerContentOperator("'", tickOperator);
            this.registerContentOperator("\"", new PdfCanvasProcessor.MoveNextLineAndShowTextWithSpacingOperator(twOperator, tcOperator, tickOperator));
            this.registerContentOperator("TJ", new PdfCanvasProcessor.ShowTextArrayOperator());
        }
    }

    @Override
    protected void eventOccurred(IEventData data, EventType type) {
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)type)) {
            this.eventListener.eventOccurred(data, type);
        }
        if (data instanceof TextRenderInfo) {
            ((TextRenderInfo)data).releaseGraphicsState();
        }
    }

    @Override
    public IEventListener getEventListener() {
        return this.eventListener;
    }
}

