/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CommonCssConstants;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssDeclaration;
import cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBorderShorthandResolver
implements IShorthandResolver {
    private static final String _0_WIDTH = "{0}-width";
    private static final String _0_STYLE = "{0}-style";
    private static final String _0_COLOR = "{0}-color";

    protected abstract String getPrefix();

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        String widthPropName = MessageFormatUtil.format(_0_WIDTH, this.getPrefix());
        String stylePropName = MessageFormatUtil.format(_0_STYLE, this.getPrefix());
        String colorPropName = MessageFormatUtil.format(_0_COLOR, this.getPrefix());
        if ("initial".equals(shorthandExpression) || "inherit".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration(widthPropName, shorthandExpression), new CssDeclaration(stylePropName, shorthandExpression), new CssDeclaration(colorPropName, shorthandExpression));
        }
        String[] props = shorthandExpression.split("\\s+");
        String borderColorValue = null;
        String borderStyleValue = null;
        String borderWidthValue = null;
        for (String value : props) {
            if ("initial".equals(value) || "inherit".equals(value)) {
                Logger logger = LoggerFactory.getLogger(AbstractBorderShorthandResolver.class);
                logger.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", shorthandExpression));
                return Collections.emptyList();
            }
            if (CommonCssConstants.BORDER_WIDTH_VALUES.contains(value) || CssUtils.isNumericValue(value) || CssUtils.isMetricValue(value) || CssUtils.isRelativeValue(value)) {
                borderWidthValue = value;
                continue;
            }
            if (CommonCssConstants.BORDER_STYLE_VALUES.contains(value) || value.equals("auto")) {
                borderStyleValue = value;
                continue;
            }
            if (!CssUtils.isColorProperty(value)) continue;
            borderColorValue = value;
        }
        ArrayList<CssDeclaration> resolvedDecl = new ArrayList<CssDeclaration>();
        resolvedDecl.add(new CssDeclaration(widthPropName, borderWidthValue == null ? "initial" : borderWidthValue));
        resolvedDecl.add(new CssDeclaration(stylePropName, borderStyleValue == null ? "initial" : borderStyleValue));
        resolvedDecl.add(new CssDeclaration(colorPropName, borderColorValue == null ? "initial" : borderColorValue));
        return resolvedDecl;
    }
}

