/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.processors.impl.font;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.layout.font.FontFamilySplitter;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssDeclaration;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FontFace {
    private final String alias;
    private final List<FontFaceSrc> sources;

    public static FontFace create(List<CssDeclaration> properties) {
        String fontFamily = null;
        String srcs = null;
        for (CssDeclaration descriptor : properties) {
            if ("font-family".equals(descriptor.getProperty())) {
                fontFamily = FontFamilySplitter.removeQuotes(descriptor.getExpression());
                continue;
            }
            if (!"src".equals(descriptor.getProperty())) continue;
            srcs = descriptor.getExpression();
        }
        if (fontFamily == null || srcs == null) {
            return null;
        }
        ArrayList<FontFaceSrc> sources = new ArrayList<FontFaceSrc>();
        for (String src : FontFace.splitSourcesSequence(srcs)) {
            FontFaceSrc source = FontFaceSrc.create(src.trim());
            if (source == null) continue;
            sources.add(source);
        }
        if (sources.size() > 0) {
            return new FontFace(fontFamily, sources);
        }
        return null;
    }

    public static String[] splitSourcesSequence(String src) {
        ArrayList<String> list = new ArrayList<String>();
        int indexToStart = 0;
        while (indexToStart < src.length()) {
            int indexToCut;
            int indexUnescapedBracket;
            int indexUnescapedOpeningQuoteMark = Math.min(CssUtils.findNextUnescapedChar(src, '\'', indexToStart) >= 0 ? CssUtils.findNextUnescapedChar(src, '\'', indexToStart) : Integer.MAX_VALUE, CssUtils.findNextUnescapedChar(src, '\"', indexToStart) >= 0 ? CssUtils.findNextUnescapedChar(src, '\"', indexToStart) : Integer.MAX_VALUE);
            if (indexUnescapedOpeningQuoteMark < (indexUnescapedBracket = CssUtils.findNextUnescapedChar(src, ')', indexToStart))) {
                indexToCut = CssUtils.findNextUnescapedChar(src, src.charAt(indexUnescapedOpeningQuoteMark), indexUnescapedOpeningQuoteMark + 1);
                if (indexToCut == -1) {
                    indexToCut = src.length();
                }
            } else {
                indexToCut = indexUnescapedBracket;
            }
            while (indexToCut < src.length() && src.charAt(indexToCut) != ',') {
                ++indexToCut;
            }
            list.add(src.substring(indexToStart, indexToCut).trim());
            indexToStart = ++indexToCut;
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public String getFontFamily() {
        return this.alias;
    }

    public List<FontFaceSrc> getSources() {
        return new ArrayList<FontFaceSrc>(this.sources);
    }

    private FontFace(String alias, List<FontFaceSrc> sources) {
        this.alias = alias;
        this.sources = new ArrayList<FontFaceSrc>(sources);
    }

    static enum FontFormat {
        None,
        TrueType,
        OpenType,
        WOFF,
        WOFF2,
        EOT,
        SVG;

    }

    static class FontFaceSrc {
        static final Pattern UrlPattern = Pattern.compile("^((local)|(url))\\((('[^']*')|(\"[^\"]*\")|([^'\"\\)]*))\\)( format\\((('[^']*')|(\"[^\"]*\")|([^'\"\\)]*))\\))?$");
        static final int TypeGroup = 1;
        static final int UrlGroup = 4;
        static final int FormatGroup = 9;
        final FontFormat format;
        final String src;
        final boolean isLocal;

        public String toString() {
            return MessageFormatUtil.format("{0}({1}){2}", this.isLocal ? "local" : "url", this.src, this.format != FontFormat.None ? MessageFormatUtil.format(" format({0})", new Object[]{this.format}) : "");
        }

        static FontFaceSrc create(String src) {
            Matcher m = UrlPattern.matcher(src);
            if (!m.matches()) {
                return null;
            }
            return new FontFaceSrc(FontFaceSrc.unquote(m.group(4)), "local".equals(m.group(1)), FontFaceSrc.parseFormat(m.group(9)));
        }

        static FontFormat parseFormat(String formatStr) {
            if (formatStr != null && formatStr.length() > 0) {
                String fontType = FontFaceSrc.unquote(formatStr).toLowerCase();
                if ("truetype".equals(fontType)) {
                    return FontFormat.TrueType;
                }
                if ("opentype".equals(fontType)) {
                    return FontFormat.OpenType;
                }
                if ("woff".equals(fontType)) {
                    return FontFormat.WOFF;
                }
                if ("woff2".equals(fontType)) {
                    return FontFormat.WOFF2;
                }
                if ("embedded-opentype".equals(fontType)) {
                    return FontFormat.EOT;
                }
                if ("svg".equals(fontType)) {
                    return FontFormat.SVG;
                }
            }
            return FontFormat.None;
        }

        static String unquote(String quotedString) {
            if (quotedString.charAt(0) == '\'' || quotedString.charAt(0) == '\"') {
                return quotedString.substring(1, quotedString.length() - 1);
            }
            return quotedString;
        }

        private FontFaceSrc(String src, boolean isLocal, FontFormat format) {
            this.format = format;
            this.src = src;
            this.isLocal = isLocal;
        }
    }
}

