/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.socket.TscConnectionSocketFactory;
import cfca.sadk.timestamp.client.socket.TscSSLHelper;
import cfca.sadk.timestamp.client.socket.TscSubjectName;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class TscLayeredConnectionSocketFactory
extends TscConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    private final SSLSocketFactory socketfactory;
    private final HostnameVerifier hostnameVerifier;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public TscLayeredConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier, long loggingWarnThresholdTime) {
        this(((SSLContext)Args.notNull((Object)sslContext, (String)"SSL context")).getSocketFactory(), supportedProtocols, supportedCipherSuites, hostnameVerifier, loggingWarnThresholdTime);
    }

    public TscLayeredConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier, long loggingWarnThresholdTime) {
        super(loggingWarnThresholdTime);
        this.socketfactory = (SSLSocketFactory)Args.notNull((Object)socketfactory, (String)"SSL socket factory");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : TscSSLHelper.getDefaultHostnameVerifier();
    }

    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        return SocketFactory.getDefault().createSocket();
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sock = super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        if (sock instanceof SSLSocket) {
            SSLSocket sslsock = (SSLSocket)sock;
            this.handshake(sslsock, context);
            this.verifyHostname(sslsock, host.getHostName(), context);
            return sock;
        }
        return this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        SSLSocket sslsock = (SSLSocket)this.socketfactory.createSocket(socket, target, port, true);
        this.setEnabledProtocolsAndCipherSuites(sslsock);
        this.prepareSocket(sslsock, context);
        this.handshake(sslsock, context);
        this.verifyHostname(sslsock, target, context);
        return sslsock;
    }

    final void setEnabledProtocolsAndCipherSuites(SSLSocket sslsock) {
        if (this.supportedProtocols != null) {
            sslsock.setEnabledProtocols(this.supportedProtocols);
        } else {
            String[] allProtocols = sslsock.getEnabledProtocols();
            ArrayList<String> enabledProtocols = new ArrayList<String>(allProtocols.length);
            for (String protocol : allProtocols) {
                if (protocol.startsWith("SSL")) continue;
                enabledProtocols.add(protocol);
            }
            if (!enabledProtocols.isEmpty()) {
                sslsock.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
            }
        }
        if (this.supportedCipherSuites != null) {
            sslsock.setEnabledCipherSuites(this.supportedCipherSuites);
        }
        if (TscLogging.DEBUG_LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("\nEnabled protocols: ");
            for (String enabledProtocol : sslsock.getEnabledProtocols()) {
                builder.append(enabledProtocol).append(",");
            }
            builder.append("\nEnabled cipher suites: ");
            for (String enabledCipherSuites : sslsock.getEnabledCipherSuites()) {
                builder.append("\n\t").append(enabledCipherSuites);
            }
            String message = builder.toString();
            TscLogging.DEBUG_LOGGER.debug(message);
        }
    }

    final void prepareSocket(SSLSocket socket, HttpContext context) throws IOException {
    }

    final SSLSession handshake(SSLSocket sslsock, HttpContext context) throws IOException {
        Args.notNull((Object)sslsock, (String)"handshake sslsock");
        String fepUUID = (String)context.getAttribute("CFCA-TSC-UUID");
        SocketAddress localAddr = sslsock.getLocalSocketAddress();
        SocketAddress remoteAddr = sslsock.getRemoteSocketAddress();
        long startTime = System.currentTimeMillis();
        try {
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sslsock {} handshake to {} starting", new Object[]{fepUUID, localAddr, remoteAddr});
            sslsock.startHandshake();
            long handshakeTime = System.currentTimeMillis() - startTime;
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sslsock {} handshake to {} successfully, handshakeTime={}ms", new Object[]{fepUUID, localAddr, remoteAddr, handshakeTime});
            if (handshakeTime > this.getLoggingWarnThresholdTime()) {
                TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} sslsock {} handshake to {} successfully, handshakeTime={}ms, warningThresholdTime={}ms", new Object[]{fepUUID, localAddr, remoteAddr, handshakeTime, this.getLoggingWarnThresholdTime()});
            }
            return sslsock.getSession();
        }
        catch (IOException e) {
            long handshakeTime = System.currentTimeMillis() - startTime;
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} sslsock {} handshake to {} failed, handshakeTime={}ms", new Object[]{fepUUID, localAddr, remoteAddr, handshakeTime, e});
            throw e;
        }
    }

    final void verifyHostname(SSLSocket sslsock, String hostname, HttpContext context) throws IOException {
        Args.notNull((Object)sslsock, (String)"handshake sslsock");
        String fepUUID = (String)context.getAttribute("CFCA-TSC-UUID");
        SocketAddress localAddr = sslsock.getLocalSocketAddress();
        SocketAddress remoteAddr = sslsock.getRemoteSocketAddress();
        if (this.hostnameVerifier instanceof TscSSLHelper.IgnoreHostnameVerifier) {
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sslsock {} handshake to {} verifyHostname ignore", new Object[]{fepUUID, localAddr, remoteAddr});
        } else {
            long startTime = System.currentTimeMillis();
            try {
                TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sslsock {} handshake to {} verifyHostname starting", new Object[]{fepUUID, localAddr, remoteAddr});
                SSLSession session = sslsock.getSession();
                if (session == null) {
                    InputStream in = sslsock.getInputStream();
                    in.available();
                    session = sslsock.getSession();
                    if (session == null) {
                        session = this.handshake(sslsock, context);
                    }
                }
                if (session == null) {
                    throw new SSLHandshakeException(String.format("CFCA-TSC-UUID=%s SSL session not available", fepUUID));
                }
                TscSSLHelper.loggingPeerCertificates(session);
                if (!this.hostnameVerifier.verify(hostname, session)) {
                    Certificate[] certs = session.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)certs[0];
                    List<TscSubjectName> subjectAlts = TscSubjectName.getSubjectAltNames(x509);
                    throw new SSLPeerUnverifiedException(String.format("CFCA-TSC-UUID=%s Certificate for <%s> doesn't match any of the subject alternative names: %s", fepUUID, hostname, subjectAlts));
                }
                long handshakeVerifyTime = System.currentTimeMillis() - startTime;
                TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sslsock {} handshake to {} verifyHostname successfully, handshakeVerifyTime={}ms", new Object[]{fepUUID, localAddr, remoteAddr, handshakeVerifyTime});
                if (handshakeVerifyTime > this.getLoggingWarnThresholdTime()) {
                    TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} sslsock {} handshake to {} verifyHostname successfully, handshakeVerifyTime={}ms, warningThresholdTime={}ms", new Object[]{fepUUID, localAddr, remoteAddr, handshakeVerifyTime, this.getLoggingWarnThresholdTime()});
                }
            }
            catch (IOException e) {
                this.closeSocket(sslsock);
                long handshakeVerifyTime = System.currentTimeMillis() - startTime;
                TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} sslsock {} handshake to {} verifyHostname failed, handshakeVerifyTime={}ms", new Object[]{fepUUID, localAddr, remoteAddr, handshakeVerifyTime, e});
                throw e;
            }
        }
    }
}

