/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.seal;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.ofd.base.asn1.SES_Signature;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.asn1.TBS_Sign;
import cfca.sadk.ofd.base.common.CFCATSAClient;
import cfca.sadk.ofd.base.common.CertVerifyUtil;
import cfca.sadk.ofd.base.common.DateFormatUtil;
import cfca.sadk.ofd.base.common.DateUtil;
import cfca.sadk.ofd.base.common.FileHashUtil;
import cfca.sadk.ofd.base.common.MechanismUtil;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.config.SignInfoConfig;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.base.seal.SealCheckUtil;
import cfca.sadk.ofd.base.seal.SealVerifyResult;
import cfca.sadk.ofd.base.util.AbstractSigner;
import cfca.sadk.ofd.base.util.SignResultInfo;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1UTCTime;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class OFDSignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(OFDSignatureUtil.class);

    public static List<byte[]> sign(byte[] sourceHash, String sourceProperty, SESeal eseal, Date signTime, SignInfoConfig signInfoConfig) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("package ofd signature start...");
        ArrayList<byte[]> resultList = new ArrayList<byte[]>();
        byte[] hashValue = null;
        if (null == sourceHash) {
            throw new IllegalArgumentException("sourceHash is null");
        }
        if (StringUtil.isEmpty(sourceProperty)) {
            throw new IllegalArgumentException("sourceProperty is null");
        }
        if (null == eseal) {
            throw new IllegalArgumentException("eseal is null");
        }
        X509Cert signCert = signInfoConfig.getSignCert();
        if (null == signCert) {
            throw new IllegalArgumentException("signCert is null");
        }
        Mechanism signAlg = signInfoConfig.getSignAlg();
        if (null == signAlg) {
            throw new IllegalArgumentException("signAlg is null");
        }
        try {
            boolean signTimeAfterTSATime;
            CFCATSAClient tsaClient;
            ASN1Integer version = new ASN1Integer(OFDConstants.GBVersion);
            DERBitString dataHash = new DERBitString(sourceHash);
            DERIA5String propertyInfo = new DERIA5String(sourceProperty);
            DEROctetString cert = new DEROctetString(signCert.getEncoding());
            ASN1ObjectIdentifier signatureAlgorithm = new ASN1ObjectIdentifier(Mechanism.getAlgorithmIdentifier((String)signAlg.getMechanismType()).getAlgorithm().getId());
            TBS_Sign toSign = null;
            if (SysEnv.isSignTimeUseTST() && (tsaClient = signInfoConfig.getTsaClient()) != null) {
                try {
                    byte[] timeStampToken = tsaClient.getGM20520Token(sourceHash);
                    signTime = CFCATSAClient.parseTime(timeStampToken);
                    businessLog.info("use timestamp time for sign time.");
                }
                catch (Exception e) {
                    businessLog.error("getTimeStamp failed", (Throwable)e);
                }
            }
            if (signInfoConfig.getSpecification() == 4 || SysEnv.isGBType()) {
                ASN1GeneralizedTime timeInfo = null;
                timeInfo = new ASN1GeneralizedTime(signTime);
                toSign = new TBS_Sign(version, eseal, timeInfo, dataHash, propertyInfo, (ASN1OctetString)cert, signatureAlgorithm);
            } else {
                version = new ASN1Integer(OFDConstants.GMVersion);
                if (signInfoConfig.getSpecification() == 2 || SysEnv.isAnKeType()) {
                    version = new ASN1Integer(OFDConstants.ANKEVersion);
                }
                byte[] signTimeBytes = DateUtil.getUTCTime(signTime);
                DERBitString octetTimeInfo = new DERBitString(signTimeBytes);
                byte[] timeStampToken = null;
                CFCATSAClient tsaClient2 = signInfoConfig.getTsaClient();
                if (tsaClient2 != null) {
                    try {
                        timeStampToken = tsaClient2.getGM20520Token(sourceHash);
                        octetTimeInfo = new DERBitString(timeStampToken);
                    }
                    catch (Exception e) {
                        businessLog.error("getTimeStamp failed", (Throwable)e);
                    }
                }
                toSign = new TBS_Sign(version, eseal, octetTimeInfo, dataHash, propertyInfo, (ASN1OctetString)cert, signatureAlgorithm);
            }
            byte[] toSignMessage = toSign.getEncoded();
            SM2PublicKey sm2PubKey = null;
            if (signCert.isSM2Cert()) {
                sm2PubKey = (SM2PublicKey)signCert.getPublicKey();
            }
            hashValue = FileHashUtil.calculateHash(toSignMessage, signAlg, sm2PubKey);
            byte[] signedValue = "".getBytes("UTF-8");
            DERBitString timestamp = null;
            byte[] timeStampToken = null;
            boolean isGBType = true;
            int spec = signInfoConfig.getSpecification();
            if (spec != -1 && 4 != spec) {
                isGBType = false;
            }
            if (!signInfoConfig.isAsyn()) {
                CFCATSAClient tsaClient3;
                AbstractSigner signer = signInfoConfig.getSigner();
                SignResultInfo signResult = signer.p1Sign(signInfoConfig, hashValue);
                if (!signResult.isSignResult()) {
                    throw new SealException("p1Sign failed", signResult.getFailReason());
                }
                signedValue = signResult.getSignData();
                if ((isGBType || SysEnv.isGBType()) && (tsaClient3 = signInfoConfig.getTsaClient()) != null) {
                    try {
                        timeStampToken = tsaClient3.getGM20520Token(signedValue);
                        timestamp = new DERBitString(timeStampToken);
                    }
                    catch (Exception e) {
                        businessLog.error("getTimeStamp failed", (Throwable)e);
                    }
                }
            }
            if (signTimeAfterTSATime = OFDSignatureUtil.checkSignTime(timeStampToken, signTime)) {
                throw new SealException("TSA time is after local time!");
            }
            DERBitString sig = new DERBitString(signedValue);
            SES_Signature sesSign = new SES_Signature(toSign, (ASN1OctetString)cert, signatureAlgorithm, sig, timestamp);
            sesSign.setGBType(isGBType);
            resultList.add(sesSign.getEncoded());
            resultList.add(hashValue);
            ArrayList<byte[]> arrayList = resultList;
            return arrayList;
        }
        catch (SealException e) {
            businessLog.error("package ofd signature failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("package ofd signature failed:", (Throwable)e);
            throw new SealException("package ofd signature failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("package ofd signature end...cost= " + (end - start) + " ms");
        }
    }

    public static SealVerifyResult verify(byte[] sourceBytes, byte[] signedData, int verifyLevel) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("verify ofd signature start...");
        try {
            byte[] orignHash;
            boolean[] keyUsage;
            boolean isRevoke;
            boolean isTrustCert;
            boolean signTimeAfterTSATime;
            Object format;
            SealVerifyResult sealVerifyResult = new SealVerifyResult();
            String failReason = null;
            SES_Signature sesSign = SES_Signature.getInstance(signedData);
            TBS_Sign toSign = sesSign.getToSign();
            ASN1OctetString signCertOctet = sesSign.getCert();
            X509Cert signCert = new X509Cert(signCertOctet.getOctets());
            ASN1ObjectIdentifier signAlg = sesSign.getSignatureAlgorithm();
            SESeal eSseal = toSign.getEseal();
            byte[] timeInfo = toSign.getTimeInfoData();
            Date signTime = null;
            int timeInfoType = toSign.getTimeInfoType();
            try {
                signTime = timeInfo.length > 50 ? CFCATSAClient.parseTime(timeInfo) : (timeInfoType == 2 ? ASN1GeneralizedTime.getInstance((Object)timeInfo).getDate() : new ASN1UTCTime(new String(timeInfo, "UTF-8")).getDate());
            }
            catch (Exception e) {
                format = new DateFormatUtil();
                signTime = ((DateFormatUtil)format).getSignTimeString(new String(timeInfo, "UTF-8"));
            }
            if (sesSign.getTimestamp() != null && (signTimeAfterTSATime = OFDSignatureUtil.checkSignTime(timeInfo = sesSign.getTimestamp().getBytes(), signTime))) {
                failReason = "TSA time is after sign time!";
                sealVerifyResult.setFailReason(failReason);
                sealVerifyResult.setFailType(9);
                OFDSignatureUtil.checkResult(sealVerifyResult);
                format = sealVerifyResult;
                return format;
            }
            sealVerifyResult.setSignTime(signTime);
            DateFormatUtil tiemFormat = new DateFormatUtil();
            businessLog.info("signTime is:" + tiemFormat.getDateString(signTime));
            if ((verifyLevel & 2) == 2 && !(isTrustCert = CertVerifyUtil.verifyCertSign(signCert))) {
                failReason = "signCert is not trusted!";
                sealVerifyResult.setFailReason(failReason);
                sealVerifyResult.setFailType(3);
                OFDSignatureUtil.checkResult(sealVerifyResult);
                SealVerifyResult end = sealVerifyResult;
                return end;
            }
            if ((verifyLevel & 4) == 4 && (isRevoke = CertVerifyUtil.verifyByCRL(signCert, signTime))) {
                DateFormatUtil format2 = new DateFormatUtil();
                failReason = "signCert is revoked at " + format2.getDateString(signTime);
                sealVerifyResult.setFailReason(failReason);
                sealVerifyResult.setFailType(4);
                OFDSignatureUtil.checkResult(sealVerifyResult);
                SealVerifyResult end = sealVerifyResult;
                return end;
            }
            if (!((verifyLevel & 8) != 8 || null != (keyUsage = CertVerifyUtil.getCertKeyUsage(signCert)) && keyUsage[0])) {
                failReason = "signCert's keyUsage not contain digitalSignature! " + Arrays.toString(keyUsage);
                sealVerifyResult.setFailReason(failReason);
                sealVerifyResult.setFailType(5);
                OFDSignatureUtil.checkResult(sealVerifyResult);
                SealVerifyResult format2 = sealVerifyResult;
                return format2;
            }
            ParamCheckUtil.checkCertValidity(signTime, signCert, verifyLevel);
            SealCheckUtil.checkSeal(eSseal, signCert, signTime, verifyLevel);
            byte[] signature = sesSign.getSignature().getBytes();
            byte[] sourceData = toSign.getEncoded();
            Signature util = new Signature();
            String signAlgString = Mechanism.getSignatureAlgName((AlgorithmIdentifier)new AlgorithmIdentifier(signAlg));
            boolean verifyResult = util.p1VerifyMessage(signAlgString, sourceData, signature, signCert.getPublicKey(), BCSoftLib.INSTANCE());
            if (!verifyResult) {
                failReason = "signature verify failed!";
                sealVerifyResult.setFailReason(failReason);
                sealVerifyResult.setFailType(2);
                OFDSignatureUtil.checkResult(sealVerifyResult);
                SealVerifyResult sealVerifyResult2 = sealVerifyResult;
                return sealVerifyResult2;
            }
            Mechanism digestAlg = MechanismUtil.getSignMechanism(signAlg);
            byte[] sourceHash = FileHashUtil.calculateHash(sourceBytes, digestAlg, null);
            if (!Arrays.equals(sourceHash, orignHash = toSign.getDataHash().getBytes())) {
                boolean checkHashStatus = false;
                if (signCert.isSM2Cert() && Arrays.equals(sourceHash = FileHashUtil.calculateHash(sourceBytes, digestAlg, (SM2PublicKey)signCert.getPublicKey()), orignHash)) {
                    checkHashStatus = true;
                }
                if (!checkHashStatus) {
                    businessLog.error("orignHash=" + Base64.toBase64String((byte[])orignHash));
                    businessLog.error("input sourceHash=" + Base64.toBase64String((byte[])sourceHash));
                    failReason = "origin hash is not equals!";
                    sealVerifyResult.setFailReason(failReason);
                    sealVerifyResult.setFailType(6);
                    OFDSignatureUtil.checkResult(sealVerifyResult);
                    SealVerifyResult sealVerifyResult3 = sealVerifyResult;
                    return sealVerifyResult3;
                }
            }
            sealVerifyResult.setVerifyResult(true);
            SealVerifyResult sealVerifyResult4 = sealVerifyResult;
            return sealVerifyResult4;
        }
        catch (SealException e) {
            businessLog.error("verify ofd signature failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("verify ofd signature failed:", (Throwable)e);
            throw new SealException("verify ofd signature failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("verify ofd signature end...cost= " + (end - start) + " ms");
        }
    }

    private static void checkResult(SealVerifyResult verifyResult) throws SealException {
        if (!verifyResult.getVerifyResult() && SysEnv.isVerifyFailedThrowException()) {
            throw new SealException(verifyResult.getFailReason());
        }
    }

    private static boolean checkSignTime(byte[] timeStampToken, Date signTime) throws IOException, SealException {
        Date tsaSignTime;
        boolean checkResult = false;
        if (timeStampToken != null && signTime.after(tsaSignTime = CFCATSAClient.parseTime(timeStampToken))) {
            businessLog.error("signTime is " + signTime + ", TSATime is " + tsaSignTime);
            checkResult = true;
        }
        return checkResult;
    }
}

