/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.graphics;

import cfca.integration.uarc.graphics.UArcShape;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class UArcGraphics {
    private BufferedImage bufferedImage;
    private Graphics2D g2d;
    private int width;
    private int height;
    private float alpha;
    private int x;
    private int y;
    private Color color;

    public UArcGraphics(int x, int y, int width, int height, Color color, float alpha) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.alpha = alpha;
        this.bufferedImage = new BufferedImage(width, height, 2);
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public void begin() {
        this.g2d = this.bufferedImage.createGraphics();
        AlphaComposite newComposite = AlphaComposite.getInstance(3, this.alpha);
        this.g2d.setComposite(newComposite);
        this.g2d.setPaint(this.color);
        this.g2d.fillRect(this.x, this.y, this.width, this.height);
    }

    public void rotate(double theta, double x, double y) {
        this.g2d.rotate(theta, x, y);
    }

    public void end() {
        this.g2d.dispose();
    }

    public void write(String formatName, OutputStream os) throws IOException {
        ImageIO.write((RenderedImage)this.bufferedImage, formatName, os);
    }

    public void draw(UArcShape shape) {
        shape.setGraphics2D(this.g2d);
        shape.draw();
    }
}

