/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz5A;
import asposewobfuscated.zz5J;
import asposewobfuscated.zz68;
import asposewobfuscated.zzAS;
import asposewobfuscated.zzAU;
import asposewobfuscated.zzL4;
import asposewobfuscated.zzME;
import asposewobfuscated.zzWQ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zz0O;
import com.aspose.words.zzYUI;
import com.aspose.words.zzZ4B;
import com.aspose.words.zzZIT;
import com.aspose.words.zzZRT;

public class FormField
extends SpecialChar {
    private zz0O zzZkh;
    private Field zzZkg;
    static String zzZkf = zz68.zzV('\u2002', 5);
    private static final zz5J zzW3 = new zz5J("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zz0O formFieldPr, zzZ4B runPr) {
        super(doc, '\u0001', runPr);
        this.zzZkh = formFieldPr;
    }

    @Override
    Node zzZ(boolean bl, zzZRT zzZRT2) throws Exception {
        FormField formField = (FormField)super.zzZ(bl, zzZRT2);
        formField.zzZkh = (zz0O)this.zzZkh.zzuY();
        formField.zzZkg = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    void zzZLu() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zz5A.zzZ(this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZtx().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n = FormField.zzQ3(this.getTextInputFormat());
                this.setResult(zzYUI.zzZB((String)newValue, n));
                break;
            }
            case 1: {
                FieldOptions fieldOptions = this.zzZRX().getFieldOptions();
                this.setResult(zzL4.zzZ(zzAU.zzq(newValue), this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                break;
            }
            case 2: {
                this.setResult(zzYUI.zzY((zzAS)newValue, this.getTextInputFormat()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
            default: {
                throw new IllegalStateException("Unknown form field type.");
            }
        }
    }

    private static int zzQ3(String string) {
        string = string.toLowerCase();
        switch (zzW3.zzWb(string)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private FieldStart zzZLt() {
        int n = 0;
        block4: for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            switch (node.getNodeType()) {
                case 22: {
                    if (n-- != 0) continue block4;
                    return (FieldStart)node;
                }
                case 24: {
                    ++n;
                    continue block4;
                }
            }
        }
        return null;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZkh.getName();
    }

    public void setName(String value) throws Exception {
        zzME.zzW((Object)value, "value");
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZkh.setName(value);
    }

    public int getType() throws Exception {
        return this.getField() != null ? this.getField().getType() : 0;
    }

    int zzZLs() throws Exception {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    Field getField() throws Exception {
        FieldStart fieldStart;
        if (this.zzZkg == null && (fieldStart = this.zzZLt()) != null) {
            this.zzZkg = fieldStart.getField();
        }
        return this.zzZkg;
    }

    public String getResult() throws Exception {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                return zz68.equals(string, zzZkf) ? "" : string;
            }
            case 71: {
                return this.getChecked() ? "1" : "0";
            }
            case 83: {
                return this.zzZLr();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzME.zzW((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                break;
            }
            case 71: {
                this.setChecked(zzL4.parseInt(value) != 0);
                break;
            }
            case 83: {
                this.zzQ2(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown form field type.");
            }
        }
    }

    public String getStatusText() {
        return this.zzZkh.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZkh.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZkh.zzZLn();
    }

    public void setOwnStatus(boolean value) {
        this.zzZkh.zzWA(value);
    }

    public String getHelpText() {
        return this.zzZkh.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZkh.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZkh.zzZLo();
    }

    public void setOwnHelp(boolean value) {
        this.zzZkh.zzWB(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZkh.zzZLp();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZkh.zzWC(value);
    }

    public String getEntryMacro() {
        return this.zzZkh.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZkh.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZkh.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZkh.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZkh.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZkh.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZkh.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZkh.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZkh.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZkh.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZkh.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZkh.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzDJ(21);
            zzZIT.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZRX());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZkh.zzZLm();
    }

    public void setMaxLength(int value) {
        this.zzZkh.zzIl(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZkh.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        if (this.zzZkh.zzZLe()) {
            return this.zzZkh.zzZLf();
        }
        return this.zzZkh.zzZLg();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZkh.zzIi(value);
    }

    String zzZLr() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    void zzQ2(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzME.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        if (this.zzZkh.zzZLh()) {
            return this.zzZkh.zzZLi();
        }
        return this.zzZkh.zzZLj();
    }

    public void setChecked(boolean value) {
        this.zzZkh.zzWx(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZkh.zzZLl();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZkh.zzWz(!value);
    }

    public double getCheckBoxSize() {
        return zzWQ.zzZw(this.zzZkh.zzZLk());
    }

    public void setCheckBoxSize(double value) {
        this.zzZkh.zzIk(zzWQ.zzu(value));
    }

    BookmarkStart getBookmarkStart() throws Exception {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zz5A.zzZ(this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zz5A.zzZ(this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    zz0O zzZLq() {
        return this.zzZkh;
    }
}

