/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.pipeline.html;

import cfca.com.itextpdf.text.Document;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import cfca.com.itextpdf.tool.xml.NoCustomContextException;
import cfca.com.itextpdf.tool.xml.Pipeline;
import cfca.com.itextpdf.tool.xml.PipelineException;
import cfca.com.itextpdf.tool.xml.ProcessObject;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.css.CssUtils;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;
import cfca.com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.ctx.MapContext;
import cfca.com.itextpdf.tool.xml.pipeline.ctx.WorkerContextImpl;
import cfca.com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.html.FileMaker;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDocPipeline
extends AbstractPipeline {
    private final FileMaker fm;
    private final String tag;
    private final String opentag;
    private final Rectangle pagesize;

    public AutoDocPipeline(FileMaker fm, String tag, String opentag, Rectangle pagesize) {
        super(null);
        this.fm = fm;
        this.tag = tag;
        this.opentag = opentag;
        this.pagesize = pagesize;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        try {
            Document d;
            MapContext cc;
            String tagName = t.getName();
            if (this.tag.equals(tagName)) {
                cc = (MapContext)context.get(PdfWriterPipeline.class.getName());
                d = new Document(this.pagesize);
                try {
                    OutputStream os = this.fm.getStream();
                    cc.put("DOCUMENT", d);
                    cc.put("WRITER", PdfWriter.getInstance(d, os));
                }
                catch (IOException e) {
                    throw new PipelineException(e);
                }
                catch (DocumentException e) {
                    throw new PipelineException(e);
                }
            }
            if (t.getName().equalsIgnoreCase(this.opentag)) {
                cc = (MapContext)context.get(PdfWriterPipeline.class.getName());
                d = (Document)cc.get("DOCUMENT");
                CssUtils cssUtils = CssUtils.getInstance();
                float pageWidth = d.getPageSize().getWidth();
                float marginLeft = 0.0f;
                float marginRight = 0.0f;
                float marginTop = 0.0f;
                float marginBottom = 0.0f;
                Map<String, String> css = t.getCSS();
                for (Map.Entry<String, String> entry : css.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.equalsIgnoreCase("margin-left")) {
                        marginLeft = cssUtils.parseValueToPt(value, pageWidth);
                        continue;
                    }
                    if (key.equalsIgnoreCase("margin-right")) {
                        marginRight = cssUtils.parseValueToPt(value, pageWidth);
                        continue;
                    }
                    if (key.equalsIgnoreCase("margin-top")) {
                        marginTop = cssUtils.parseValueToPt(value, pageWidth);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("margin-bottom")) continue;
                    marginBottom = cssUtils.parseValueToPt(value, pageWidth);
                }
                d.setMargins(marginLeft, marginRight, marginTop, marginBottom);
                d.open();
            }
        }
        catch (NoCustomContextException e) {
            throw new PipelineException(LocaleMessages.getInstance().getMessage("pipeline.autodoc.missingdep"), e);
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        String tagName = t.getName();
        if (this.tag.equals(tagName)) {
            try {
                MapContext cc = (MapContext)context.get(PdfWriterPipeline.class.getName());
                Document d = (Document)cc.get("DOCUMENT");
                d.close();
            }
            catch (NoCustomContextException e) {
                throw new PipelineException("AutoDocPipeline depends on PdfWriterPipeline.", e);
            }
            try {
                HtmlPipelineContext hpc = (HtmlPipelineContext)context.get(HtmlPipeline.class.getName());
                HtmlPipelineContext clone = hpc.clone();
                clone.setPageSize(this.pagesize);
                ((WorkerContextImpl)context).put(HtmlPipeline.class.getName(), clone);
            }
            catch (NoCustomContextException e) {
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        return this.getNext();
    }
}

