/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.processors.impl;

import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.layout.font.FontInfo;
import cfca.sadk.com.itextpdf.layout.font.FontProvider;
import cfca.sadk.com.itextpdf.layout.font.FontSet;
import cfca.sadk.com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import cfca.sadk.com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import cfca.sadk.com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import cfca.sadk.com.itextpdf.svg.processors.ISvgConverterProperties;

public class SvgProcessorContext {
    private FontProvider fontProvider;
    private FontSet tempFonts;
    private ResourceResolver resourceResolver;
    private MediaDeviceDescription deviceDescription;

    public SvgProcessorContext(ISvgConverterProperties converterProperties) {
        String baseUri;
        this.deviceDescription = converterProperties.getMediaDeviceDescription();
        if (this.deviceDescription == null) {
            this.deviceDescription = MediaDeviceDescription.getDefault();
        }
        this.fontProvider = converterProperties.getFontProvider();
        if (this.fontProvider == null) {
            this.fontProvider = new BasicFontProvider();
        }
        if ((baseUri = converterProperties.getBaseUri()) == null) {
            baseUri = "";
        }
        this.resourceResolver = new ResourceResolver(baseUri);
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public MediaDeviceDescription getDeviceDescription() {
        return this.deviceDescription;
    }

    public FontSet getTempFonts() {
        return this.tempFonts;
    }

    public void addTemporaryFont(FontProgram fontProgram, String encoding, String alias) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontProgram, encoding, alias);
    }

    public void addTemporaryFont(FontInfo fontInfo, String alias) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontInfo, alias);
    }
}

