/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import java.io.IOException;
import java.security.PrivateKey;

public final class SM2CardInternalPrivateKey
implements GMTKey,
SM2CardKey,
PrivateKey {
    private static final long serialVersionUID = 7992913473812868517L;
    private final int bitLength;
    private final int keyIndex;
    private final int keyUsage;
    private final int curveId = 4165;
    private final SM2CardPublicKey pubKey;

    SM2CardInternalPrivateKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("SM2CardInternalPrivateKey invalid keyIndex = " + keyIndex);
        }
        this.bitLength = SM2CardBigIntegers.parseBitLength(pubKeyData);
        this.keyIndex = keyIndex;
        this.keyUsage = keyUsage;
        this.pubKey = SM2CardPublicKey.buildInternalKey(keyIndex, keyUsage, pubKeyData);
    }

    public boolean isInternalKey() {
        return true;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public int modulusBitsLength() {
        return this.bitLength;
    }

    public int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public byte[] keyData() throws CryptoException {
        return this.pubKey == null ? null : this.pubKey.keyData();
    }

    public String dumpPublicKey() {
        return this.pubKey == null ? null : this.pubKey.dumpPublicKey();
    }

    public byte[] getPubX() {
        return this.pubKey == null ? null : this.pubKey.getPubX();
    }

    public byte[] getPubY() {
        return this.pubKey == null ? null : this.pubKey.getPubY();
    }

    public byte[] getDefaultZ() {
        return this.pubKey == null ? null : this.pubKey.getDefaultZ();
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERUTF8String("SM2"));
            v.add(new ASN1Integer(this.keyIndex));
            v.add(new ASN1Integer(this.keyUsage));
            v.add(new ASN1Integer(4165L));
            v.add(new ASN1Integer(this.pubKey.getPubX_Int()));
            v.add(new ASN1Integer(this.pubKey.getPubY_Int()));
            DERSequence value = new DERSequence(v);
            return value.getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException("SM2CardInternalPrivateKey getEncoded() failed", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SM2CardInternalPrivateKey [bitLength=").append(this.bitLength);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",curveId=").append(4165);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",defZ=").append(DataHelper.toHexString(this.getDefaultZ()));
        builder.append("]");
        return builder.toString();
    }
}

