/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.transaction.util;

import cfca.paperless.base.bean.response.CompoundSealPdfListResponseBodyBean;
import cfca.paperless.base.bean.response.DownloadProofFileResponseBodyBean;
import cfca.paperless.base.bean.response.DownloadTemplateResponseBodyBean;
import cfca.paperless.base.bean.response.MakeImageResponseBodyBean;
import cfca.paperless.base.bean.response.MessageSealResponseBodyBean;
import cfca.paperless.base.bean.response.ResponseBodyBean;
import cfca.paperless.base.bean.response.SynthesizeAndCompoundSealResponseBodyBean;
import cfca.paperless.base.bean.response.WebSealResponseBodyBean;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.sadk.util.Base64;

public class ResponseJSONBodyFactory {
    public static String getJSONBodyStrForTx1007(String outputFilepath, String pdfFileDataHash) throws Exception {
        ResponseBodyBean responseBodyBean = new ResponseBodyBean();
        if (StringUtil.isNotEmpty(outputFilepath)) {
            responseBodyBean.setOutputFilepath(outputFilepath);
        }
        if (StringUtil.isNotEmpty(pdfFileDataHash)) {
            responseBodyBean.setPdfFileDataHash(pdfFileDataHash);
        }
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrForTx4003(CompoundSealPdfListResponseBodyBean responseBodyBean) throws Exception {
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrForTx1002(String templateCode, String templateName, String templateFormat, String pdfFileDataHash) throws Exception {
        DownloadTemplateResponseBodyBean responseBodyBean = new DownloadTemplateResponseBodyBean(templateCode, templateName, templateFormat, pdfFileDataHash);
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrForTx4016(String htmlHash, String signData) throws Exception {
        String htmlHashBase64String = new String(Base64.encode((byte[])htmlHash.getBytes("UTF-8")), "UTF-8");
        WebSealResponseBodyBean responseBodyBean = new WebSealResponseBodyBean(htmlHashBase64String, signData);
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrForTx4017(byte[] base64P7SignedData) throws Exception {
        MessageSealResponseBodyBean responseBodyBean = new MessageSealResponseBodyBean(new String(base64P7SignedData, "UTF-8"));
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrForTx2001(byte[] imageData) throws Exception {
        String imageBase64String = new String(Base64.encode((byte[])imageData), "UTF-8");
        MakeImageResponseBodyBean responseBodyBean = new MakeImageResponseBodyBean(imageBase64String);
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrFor6002(String pdfFileDataHash) throws Exception {
        DownloadProofFileResponseBodyBean responseBodyBean = new DownloadProofFileResponseBodyBean();
        if (StringUtil.isNotEmpty(pdfFileDataHash)) {
            responseBodyBean.setPdfFileDataHash(pdfFileDataHash);
        }
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }

    public static String getJSONBodyStrForTx8001(String outputFilePathForSynthesized, String outputFilepath, String pdfFileDataHash) throws Exception {
        SynthesizeAndCompoundSealResponseBodyBean responseBodyBean = new SynthesizeAndCompoundSealResponseBodyBean();
        if (StringUtil.isNotEmpty(outputFilePathForSynthesized)) {
            responseBodyBean.setOutputFilepathForSynthesized(outputFilePathForSynthesized);
        }
        if (StringUtil.isNotEmpty(outputFilepath)) {
            responseBodyBean.setOutputFilepath(outputFilepath);
        }
        if (StringUtil.isNotEmpty(pdfFileDataHash)) {
            responseBodyBean.setPdfFileDataHash(pdfFileDataHash);
        }
        String responseBodyBeanJSONStr = JsonUtil.obj2Json(responseBodyBean);
        return responseBodyBeanJSONStr;
    }
}

