/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import java.io.IOException;

public class CertInfoList
extends ASN1Object {
    private ASN1Sequence content;

    private CertInfoList(ASN1Sequence seq) {
        this.content = seq;
    }

    public static CertInfoList getInstance(Object o) {
        if (o instanceof CertInfoList) {
            return (CertInfoList)((Object)o);
        }
        if (o != null) {
            return new CertInfoList(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public Certificate[] toCertificateArray() throws PKIException, IOException {
        Certificate[] result = new Certificate[this.content.size()];
        for (int i = 0; i != result.length; ++i) {
            if (this.content.getObjectAt(i) instanceof ASN1OctetString) {
                byte[] certData = ASN1OctetString.getInstance((Object)this.content.getObjectAt(i)).getOctets();
                result[i] = Certificate.getInstance((Object)certData);
                continue;
            }
            result[i] = Certificate.getInstance((Object)this.content.getObjectAt(i));
        }
        return result;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

