/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.html.simpleparser;

import cfca.com.itextpdf.text.html.HtmlUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedProperties {
    public List<TagAttributes> chain = new ArrayList<TagAttributes>();

    public String getProperty(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            TagAttributes p = this.chain.get(k);
            Map<String, String> attrs = p.attrs;
            String ret = attrs.get(key);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean hasProperty(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            TagAttributes p = this.chain.get(k);
            Map<String, String> attrs = p.attrs;
            if (!attrs.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public void addToChain(String tag, Map<String, String> props) {
        this.adjustFontSize(props);
        this.chain.add(new TagAttributes(tag, props));
    }

    public void removeChain(String tag) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            if (!tag.equals(this.chain.get((int)k).tag)) continue;
            this.chain.remove(k);
            return;
        }
    }

    protected void adjustFontSize(Map<String, String> attrs) {
        String value = attrs.get("size");
        if (value == null) {
            return;
        }
        if (value.endsWith("pt")) {
            attrs.put("size", value.substring(0, value.length() - 2));
            return;
        }
        String old = this.getProperty("size");
        attrs.put("size", Integer.toString(HtmlUtilities.getIndexedFontSize(value, old)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TagAttributes {
        final String tag;
        final Map<String, String> attrs;

        TagAttributes(String tag, Map<String, String> attrs) {
            this.tag = tag;
            this.attrs = attrs;
        }
    }
}

