/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.css;

import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.css.CssSelectorItem;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSelector {
    private List<CssSelectorItem> selectorItems;

    public CssSelector(List<CssSelectorItem> selector) {
        this.selectorItems = selector;
    }

    public boolean matches(Tag t) {
        return this.matches(t, this.selectorItems.size() - 1);
    }

    private boolean matches(Tag t, int index) {
        if (t == null) {
            return false;
        }
        Stack<CssSelectorItem> currentSelector = new Stack<CssSelectorItem>();
        while (index >= 0 && this.selectorItems.get(index).getSeparator() == '\u0000') {
            currentSelector.push(this.selectorItems.get(index));
            --index;
        }
        while (!currentSelector.empty()) {
            if (((CssSelectorItem)currentSelector.pop()).matches(t)) continue;
            return false;
        }
        if (index == -1) {
            return true;
        }
        char separator = this.selectorItems.get(index).getSeparator();
        if (separator == '\u0000') {
            return false;
        }
        --index;
        switch (separator) {
            case '>': {
                return this.matches(t.getParent(), index);
            }
            case ' ': {
                while (t != null) {
                    if (this.matches(t.getParent(), index)) {
                        return true;
                    }
                    t = t.getParent();
                }
                return false;
            }
            case '~': {
                if (!t.hasParent()) {
                    return false;
                }
                for (int precededIndex = t.getParent().getChildren().indexOf(t) - 1; precededIndex >= 0; --precededIndex) {
                    if (!this.matches(t.getParent().getChildren().get(precededIndex), index)) continue;
                    return true;
                }
                return false;
            }
            case '+': {
                if (!t.hasParent()) {
                    return false;
                }
                int precededIndex = t.getParent().getChildren().indexOf(t) - 1;
                return precededIndex >= 0 && this.matches(t.getParent().getChildren().get(precededIndex), index);
            }
        }
        return false;
    }

    public int calculateSpecifity() {
        int specifity = 0;
        for (CssSelectorItem item : this.selectorItems) {
            specifity += item.getSpecificity();
        }
        return specifity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (CssSelectorItem item : this.selectorItems) {
            buf.append(item.toString());
        }
        return buf.toString();
    }
}

