/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout;

import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.geom.PageSize;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.layout.RootElement;
import cfca.sadk.com.itextpdf.layout.element.AreaBreak;
import cfca.sadk.com.itextpdf.layout.element.IBlockElement;
import cfca.sadk.com.itextpdf.layout.element.IElement;
import cfca.sadk.com.itextpdf.layout.element.ILargeElement;
import cfca.sadk.com.itextpdf.layout.renderer.DocumentRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.RootRenderer;

public class Document
extends RootElement<Document> {
    protected float leftMargin = 36.0f;
    protected float rightMargin = 36.0f;
    protected float topMargin = 36.0f;
    protected float bottomMargin = 36.0f;

    public Document(PdfDocument pdfDoc) {
        this(pdfDoc, pdfDoc.getDefaultPageSize());
    }

    public Document(PdfDocument pdfDoc, PageSize pageSize) {
        this(pdfDoc, pageSize, true);
    }

    public Document(PdfDocument pdfDoc, PageSize pageSize, boolean immediateFlush) {
        this.pdfDocument = pdfDoc;
        this.pdfDocument.setDefaultPageSize(pageSize);
        this.immediateFlush = immediateFlush;
    }

    @Override
    public void close() {
        if (this.rootRenderer != null) {
            this.rootRenderer.close();
        }
        this.pdfDocument.close();
    }

    public Document add(AreaBreak areaBreak) {
        this.checkClosingStatus();
        this.childElements.add(areaBreak);
        this.ensureRootRendererNotNull().addChild(areaBreak.createRendererSubTree());
        if (this.immediateFlush) {
            this.childElements.remove(this.childElements.size() - 1);
        }
        return this;
    }

    @Override
    public Document add(IBlockElement element) {
        this.checkClosingStatus();
        super.add(element);
        if (element instanceof ILargeElement) {
            ((ILargeElement)((Object)element)).setDocument(this);
            ((ILargeElement)((Object)element)).flushContent();
        }
        return this;
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public void setRenderer(DocumentRenderer documentRenderer) {
        this.rootRenderer = documentRenderer;
    }

    public void flush() {
        this.rootRenderer.flush();
    }

    public void relayout() {
        IRenderer nextRelayoutRenderer;
        if (this.immediateFlush) {
            throw new IllegalStateException("Operation not supported with immediate flush");
        }
        IRenderer iRenderer = nextRelayoutRenderer = this.rootRenderer != null ? this.rootRenderer.getNextRenderer() : null;
        if (nextRelayoutRenderer == null || !(nextRelayoutRenderer instanceof RootRenderer)) {
            nextRelayoutRenderer = new DocumentRenderer(this, this.immediateFlush);
        }
        while (this.pdfDocument.getNumberOfPages() > 0) {
            this.pdfDocument.removePage(this.pdfDocument.getNumberOfPages());
        }
        this.rootRenderer = (RootRenderer)nextRelayoutRenderer;
        for (IElement element : this.childElements) {
            this.rootRenderer.addChild(element.createRendererSubTree());
        }
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(float leftMargin) {
        this.leftMargin = leftMargin;
    }

    public float getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(float rightMargin) {
        this.rightMargin = rightMargin;
    }

    public float getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(float topMargin) {
        this.topMargin = topMargin;
    }

    public float getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(float bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setMargins(float topMargin, float rightMargin, float bottomMargin, float leftMargin) {
        this.setTopMargin(topMargin);
        this.setRightMargin(rightMargin);
        this.setBottomMargin(bottomMargin);
        this.setLeftMargin(leftMargin);
    }

    public Rectangle getPageEffectiveArea(PageSize pageSize) {
        return new Rectangle(pageSize.getLeft() + this.leftMargin, pageSize.getBottom() + this.bottomMargin, pageSize.getWidth() - this.leftMargin - this.rightMargin, pageSize.getHeight() - this.bottomMargin - this.topMargin);
    }

    @Override
    protected RootRenderer ensureRootRendererNotNull() {
        if (this.rootRenderer == null) {
            this.rootRenderer = new DocumentRenderer(this, this.immediateFlush);
        }
        return this.rootRenderer;
    }

    protected void checkClosingStatus() {
        if (this.getPdfDocument().isClosed()) {
            throw new PdfException("Document was closed. It is impossible to execute action.");
        }
    }
}

