/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.kernel.color.DeviceRgb;
import cfca.sadk.seal.base.util.DpiUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static final int defaultDPI = 96;
    public static final float ratio = 72.0f;

    public static byte[] transferAlpha(byte[] imageByte) throws CodeException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIcon imageIcon = new ImageIcon(imageByte);
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
            Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
            g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
            int alpha = 0;
            for (int j1 = bufferedImage.getMinY(); j1 < bufferedImage.getHeight(); ++j1) {
                for (int j2 = bufferedImage.getMinX(); j2 < bufferedImage.getWidth(); ++j2) {
                    int rgb = bufferedImage.getRGB(j2, j1);
                    int r = (rgb & 0xFF0000) >> 16;
                    int g = (rgb & 0xFF00) >> 8;
                    int b = rgb & 0xFF;
                    if (255 - r < 30 && 255 - g < 30 && 255 - b < 30) {
                        rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                    }
                    bufferedImage.setRGB(j2, j1, rgb);
                }
            }
            g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new CodeException("600709", e);
        }
    }

    public static byte[] resizeImage(byte[] imageByte, int width, int height) throws CodeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage srcImg = ImageIO.read(bais);
            BufferedImage buffImg = null;
            buffImg = new BufferedImage(width, height, 6);
            buffImg.getGraphics().drawImage(srcImg.getScaledInstance(width, height, 4), 0, 0, null);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (Exception e) {
            throw new CodeException("600709", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] resizeImageWithDpi(byte[] imageByte, int width, int height, int dpi) throws CodeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        byte[] imageData = null;
        try {
            BufferedImage srcImg = ImageIO.read(bais);
            BufferedImage buffImg = null;
            buffImg = new BufferedImage(width, height, 6);
            buffImg.getGraphics().drawImage(srcImg.getScaledInstance(width, height, 4), 0, 0, null);
            imageData = DpiUtils.process((BufferedImage)buffImg, (int)dpi);
        }
        catch (Exception e) {
            throw new CodeException("600709", e);
        }
        return imageData;
    }

    public static byte[] resizeImageOptimized(byte[] imageByte, int width, int height) throws CodeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage bufferedImage = ImageIO.read(bais);
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            double scaleW = (double)width / (double)w;
            double scaleH = (double)height / (double)h;
            if (scaleW > scaleH) {
                height = (int)((double)h * scaleW);
            } else {
                width = (int)((double)w * scaleH);
            }
            BufferedImage buffImg = null;
            buffImg = new BufferedImage(width, height, 6);
            buffImg.getGraphics().drawImage(bufferedImage.getScaledInstance(width, height, 4), 0, 0, null);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (Exception e) {
            throw new CodeException("600709", "image", (Throwable)e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static double calculateImageCoefficient(byte[] imageByte, int width, int height) throws CodeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        try {
            BufferedImage bufferedImage = ImageIO.read(bais);
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            double scaleW = (double)width / (double)w;
            double scaleH = (double)height / (double)h;
            if (scaleW > scaleH) {
                return scaleW > 1.47 ? 1.47 : scaleW;
            }
            return scaleH > 1.47 ? 1.47 : scaleH;
        }
        catch (Exception e) {
            throw new CodeException("600709", "image", (Throwable)e);
        }
    }

    public static float[] getImageWidth(byte[] imageBytes) {
        ImageData imageData = ImageDataFactory.create((byte[])imageBytes);
        int dpiX = imageData.getDpiX();
        int dpiY = imageData.getDpiY();
        int xDPI = dpiX == 0 ? 96 : dpiX;
        int yDPI = dpiY == 0 ? 96 : dpiY;
        float width = imageData.getWidth() * 72.0f / (float)xDPI;
        float height = imageData.getHeight() * 72.0f / (float)yDPI;
        return new float[]{width, height};
    }

    public static DeviceRgb hex2RGB(String colorHex) {
        String patten = "^[a-zA-Z0-9]{6}$";
        boolean isColorCode = colorHex.matches(patten);
        if (isColorCode) {
            int r = Integer.parseInt(colorHex.substring(0, 2), 16);
            int g = Integer.parseInt(colorHex.substring(2, 4), 16);
            int b = Integer.parseInt(colorHex.substring(4, 6), 16);
            return new DeviceRgb(r, g, b);
        }
        return null;
    }

    public static Color hex2Color(String colorHex) {
        String patten = "^[a-zA-Z0-9]{6}$";
        boolean isColorCode = colorHex.matches(patten);
        if (isColorCode) {
            int r = Integer.parseInt(colorHex.substring(0, 2), 16);
            int g = Integer.parseInt(colorHex.substring(2, 4), 16);
            int b = Integer.parseInt(colorHex.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        return null;
    }
}

