/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzAS;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.zzBT;
import com.aspose.words.zzD3;
import com.aspose.words.zzET;
import com.aspose.words.zzFF;
import com.aspose.words.zzJY;
import com.aspose.words.zzKD;
import com.aspose.words.zzKH;
import com.aspose.words.zzLC;
import com.aspose.words.zzN4;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable {
    private zzN4 zz3J;

    ChartSeriesCollection(zzN4 dmlChart) {
        this.zz3J = dmlChart;
    }

    public ChartSeries get(int index) {
        return (ChartSeries)this.zzpX().get(index);
    }

    public Iterator iterator() {
        return this.zzpX().iterator();
    }

    public void removeAt(int index) {
        this.zzpX().remove(index);
    }

    public void clear() {
        this.zzpX().clear();
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, values);
        chartSeries.zzq6().zzY(ChartSeriesCollection.zzQ(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzq6().zzY(ChartSeriesCollection.zzX(xValues));
        return chartSeries;
    }

    ChartSeries zzZ(String string, zzAS[] zzASArray, double[] dArray) {
        if (zzASArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzASArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzASArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(string, dArray);
        chartSeries.zzq6().zzY(ChartSeriesCollection.zzZ(zzASArray));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZ(seriesName, zzAS.zzZ(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zz3J.zziU() != 15) {
            this.zz3J.zzU(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzqc().zzqo().zzS(3, this.zz3J.zzhK());
        chartSeries.zzq6().zzY(ChartSeriesCollection.zzX(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzq2().zzY(ChartSeriesCollection.zzX(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zz3J);
        chartSeries.setName(string);
        this.zzX(chartSeries);
        chartSeries.setIndex(this.zz3J.zzhN().size());
        chartSeries.zzSf(chartSeries.getIndex());
        chartSeries.zzq4().zzY(ChartSeriesCollection.zzX(dArray));
        chartSeries.zzq5().zzY(chartSeries.zzq4().zzga());
        this.zz3J.zzU(chartSeries);
        return chartSeries;
    }

    private void zzX(ChartSeries chartSeries) {
        chartSeries.zzqc().zzqo().zzS(5, new zzKH());
        switch (this.zz3J.zziU()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ(chartSeries, 5);
                break;
            }
            case 4: {
                ChartSeriesCollection.zzZ(chartSeries, 5);
                ChartSeriesCollection.zzV(chartSeries);
                break;
            }
            case 6: {
                ChartSeriesCollection.zzZ(chartSeries, 1);
                ChartSeriesCollection.zzV(chartSeries);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzW(chartSeries);
                break;
            }
        }
    }

    private static void zzW(ChartSeries chartSeries) {
        zzKH zzKH2 = new zzKH();
        zzKH2.zzZ(new zzET());
        zzD3 zzD32 = new zzD3();
        zzD32.setValue(1);
        zzKH2.zzc3().zzZ(new zzBT(zzD32));
        zzKH2.zzc3().zzYr(19050.0);
        chartSeries.zzqc().zzqo().zzS(5, zzKH2);
    }

    private static void zzV(ChartSeries chartSeries) {
        zzKH zzKH2 = new zzKH();
        zzKH2.zzZ(new zzET());
        zzKH2.zzc3().zzZ(new zzFF());
        zzKH2.zzc3().setEndCap(0);
        zzKH2.zzc3().zzYr(19050.0);
        chartSeries.zzqc().zzqo().zzS(5, zzKH2);
    }

    private static void zzZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzqe().zzS(0, n);
        chartSeries.zzqc().zzqo().zzS(4, chartMarker);
    }

    private static zzJY zzX(double[] dArray) {
        int n = 0;
        zzJY zzJY2 = new zzJY(2, false);
        for (double d : dArray) {
            zzJY2.zzV(new zzLC(n++, d, "General"));
        }
        zzJY2.zzPS(dArray.length);
        zzJY2.zzaQ();
        return zzJY2;
    }

    private static zzJY zzZ(zzAS[] zzASArray) {
        int n = 0;
        zzJY zzJY2 = new zzJY(2, false);
        for (zzAS zzAS2 : zzASArray) {
            zzJY2.zzV(new zzLC(n++, zzAS2.zzAI(), "m/d/yyyy"));
        }
        zzJY2.zzPS(zzASArray.length);
        zzJY2.zzaQ();
        return zzJY2;
    }

    private static zzJY zzQ(String[] stringArray) {
        int n = 0;
        zzJY zzJY2 = new zzJY(1, false);
        for (String string : stringArray) {
            zzJY2.zzV(new zzKD(n++, string));
        }
        zzJY2.zzPS(stringArray.length);
        zzJY2.zzaQ();
        return zzJY2;
    }

    public int getCount() {
        return this.zzpX().size();
    }

    private ArrayList zzpX() {
        return this.zz3J.zzhN();
    }
}

