/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.util;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.Units;

public final class NumberUtil {
    public static byte[] colorStringToRgb(String str) {
        byte[] rgb = new byte[]{0, 0, 0};
        if (StringUtils.isEmpty((CharSequence)str)) {
            return rgb;
        }
        if (str.contains("#")) {
            str = str.replace("#", "");
            if ((str = str.trim()).length() == 6) {
                rgb[0] = (byte)Short.parseShort(str.substring(0, 2), 16);
                rgb[1] = (byte)Short.parseShort(str.substring(2, 4), 16);
                rgb[2] = (byte)Short.parseShort(str.substring(4, 6), 16);
            }
        } else if (str.contains("rgb")) {
            str = str.replace("rgb(", "");
            String[] split = (str = str.replace(")", "")).split(",");
            if (split.length == 3) {
                rgb[0] = (byte)Short.parseShort(StringUtils.trim((String)split[0]));
                rgb[1] = (byte)Short.parseShort(StringUtils.trim((String)split[1]));
                rgb[2] = (byte)Short.parseShort(StringUtils.trim((String)split[2]));
            }
        }
        return rgb;
    }

    public static String rgbToColorString(byte[] rgb) {
        if (rgb == null || rgb.length != 3) {
            return null;
        }
        return String.format("rgb(%d,%d,%d)", rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF);
    }

    public static int pixel2Twips(int pixel) {
        return (int)Math.round(Units.pixelToPoints((double)pixel) * 20.0);
    }

    public static int twips2Pixel(int twips) {
        return Units.pointsToPixel((double)((double)twips / 20.0));
    }

    public static int pixel2PoiColWidth(int pixel) {
        return Math.round((float)pixel / 7.0017f * 256.0f);
    }

    public static int pixel2CharacterLen(int pixel) {
        return Math.round((float)pixel / 7.0017f);
    }

    public static int characterLen2Pixel(int characterLen) {
        return Math.round((float)characterLen * 7.0017f);
    }

    public static int emu2Pixel(double emu) {
        return (int)Math.round(emu / 9525.0);
    }

    public static int pixelToEMU(float pixels) {
        return Math.round(pixels * 9525.0f);
    }

    @Generated
    private NumberUtil() {
    }
}

