/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session;

public final class CryptoInfo {
    public static final int SM2CARD = 1;
    public static final int RSACARD = 2;
    public static final int ECCCARD = 4;
    private final int cardEnableType;
    private final String sdfLibPath;
    private final int warningTimeThreshold;
    private final int warningLongTimeThreshold;
    private final int sessionNumber;
    private final int sessionTimeout;
    private final boolean enableSM2Card;
    private final boolean enableRSACard;
    private final boolean enableECCCard;
    private final boolean supportIdleTest;

    public CryptoInfo(int cardEnableType, String sdfLibPath, int warningTimeThreshold, int warningLongTimeThreshold, int sessionNumber, int sessionTimeout) {
        this(cardEnableType, sdfLibPath, warningTimeThreshold, warningLongTimeThreshold, sessionNumber, sessionTimeout, true);
    }

    public CryptoInfo(int cardEnableType, String sdfLibPath, int warningTimeThreshold, int warningLongTimeThreshold, int sessionNumber, int sessionTimeout, boolean supportIdleTest) {
        this.cardEnableType = cardEnableType;
        this.sdfLibPath = sdfLibPath;
        this.warningTimeThreshold = warningTimeThreshold;
        this.warningLongTimeThreshold = warningLongTimeThreshold;
        this.sessionNumber = sessionNumber;
        this.sessionTimeout = sessionTimeout;
        this.enableSM2Card = (1 & cardEnableType) == 1;
        this.enableRSACard = (2 & cardEnableType) == 2;
        this.enableECCCard = (4 & cardEnableType) == 4;
        this.supportIdleTest = supportIdleTest;
    }

    public int getCardEnableType() {
        return this.cardEnableType;
    }

    public String getSdfLibPath() {
        return this.sdfLibPath;
    }

    public int getWarningTimeThreshold() {
        return this.warningTimeThreshold;
    }

    public int getWarningLongTimeThreshold() {
        return this.warningLongTimeThreshold;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isEnableSM2Card() {
        return this.enableSM2Card;
    }

    public boolean isEnableRSACard() {
        return this.enableRSACard;
    }

    public boolean isEnableECCCard() {
        return this.enableECCCard;
    }

    public boolean isEnableCard() {
        return this.enableSM2Card || this.enableRSACard || this.enableECCCard;
    }

    public boolean isSupportIdleTest() {
        return this.supportIdleTest;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CryptoInfo [cardEnableType=");
        builder.append(this.cardEnableType);
        builder.append(", sdfLibPath=");
        builder.append(this.sdfLibPath);
        builder.append(", warningTimeThreshold=");
        builder.append(this.warningTimeThreshold);
        builder.append(", sessionNumber=");
        builder.append(this.sessionNumber);
        builder.append(", sessionTimeout=");
        builder.append(this.sessionTimeout);
        builder.append(", warningLongTimeThreshold=");
        builder.append(this.warningLongTimeThreshold);
        builder.append(", enableSM2Card=");
        builder.append(this.enableSM2Card);
        builder.append(", enableRSACard=");
        builder.append(this.enableRSACard);
        builder.append(", enableECCCard=");
        builder.append(this.enableECCCard);
        builder.append(", supportIdleTest=");
        builder.append(this.supportIdleTest);
        builder.append("]");
        return builder.toString();
    }
}

