/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.common.DateUtil;
import cfca.sadk.ofd.base.common.FileHashUtil;
import cfca.sadk.ofd.base.common.ImageUtil;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.SignAppearance;
import cfca.sadk.ofd.base.config.SignInfoConfig;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.base.ofd.SimpleTextParser;
import cfca.sadk.ofd.base.seal.OFDSignatureUtil;
import cfca.sadk.ofd.base.seal.SealCheckUtil;
import cfca.sadk.ofd.base.seal.SealInfo;
import cfca.sadk.ofd.base.seal.SealResultInfo;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import cfca.sadk.ofd.base.tax.TaxUtil;
import cfca.sadk.ofd.util.MakeSealUtil;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class SignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(SignatureUtil.class);

    public static SealResultInfo signLocation(byte[] ofdDatas, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        try {
            Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
            return SignatureUtil.p1Sign(filesMap, eSseal, appearance, signInfo);
        }
        catch (SealException e) {
            businessLog.error("signLocation failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signLocation failed:", (Throwable)e);
            throw new SealException("signLocation failed:", e);
        }
    }

    public static SealResultInfo signLocation(InputStream ofdInputStream, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException, IOException {
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInpuStream is null!");
        }
        try {
            Map<String, byte[]> filesMap = ZipUtil.uncompress(ofdInputStream);
            SealResultInfo sealResultInfo = SignatureUtil.p1Sign(filesMap, eSseal, appearance, signInfo);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signLocation failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signLocation failed:", (Throwable)e);
            throw new SealException("signLocation failed:", e);
        }
        finally {
            ofdInputStream.close();
        }
    }

    public static SealResultInfo signKeyword(byte[] ofdDatas, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException, IOException {
        if (null == appearance) {
            throw new IllegalArgumentException("appearance is null!");
        }
        if (StringUtil.isEmpty(appearance.getKeyword())) {
            throw new IllegalArgumentException("keyword is null!");
        }
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        return SignatureUtil.signKeyword(new ByteArrayInputStream(ofdDatas), eSseal, appearance, signInfo);
    }

    public static SealResultInfo signKeyword(InputStream ofdInputStream, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException, IOException {
        if (null == appearance) {
            throw new IllegalArgumentException("appearance is null!");
        }
        if (StringUtil.isEmpty(appearance.getKeyword())) {
            throw new IllegalArgumentException("keyword is null!");
        }
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInputStream is null!");
        }
        SimpleTextParser parser = null;
        try {
            Map<String, byte[]> filesMap = ZipUtil.uncompress(ofdInputStream);
            parser = new SimpleTextParser();
            List<Rectangle> keywordList = null;
            String keyword = appearance.getKeyword();
            int keywordIndex = appearance.getKeywordIndex();
            int[] pageArray = appearance.getPageArray();
            int totalPages = SealXMLUtil.getTotalPages(filesMap);
            int[] pageNums = pageArray;
            if (null == pageNums) {
                if (appearance.isUsePageRange()) {
                    int startPage = appearance.getStartPage();
                    int endPage = appearance.getEndPage();
                    if (startPage <= 0) {
                        startPage = 1;
                    }
                    if (endPage == -1) {
                        endPage = totalPages;
                    }
                    ParamCheckUtil.checkPageNum(startPage, totalPages);
                    ParamCheckUtil.checkPageNum(endPage, totalPages);
                    if (startPage > endPage) {
                        throw new SealException("startPageNum " + startPage + " is larger than endPageNum " + endPage);
                    }
                    int pageRangeLength = endPage - startPage + 1;
                    pageNums = new int[pageRangeLength];
                    int i = startPage;
                    int j = 0;
                    while (i <= endPage) {
                        if (i > startPage && i < endPage) {
                            ParamCheckUtil.checkPageNum(i, totalPages);
                        }
                        pageNums[j] = i++;
                        ++j;
                    }
                } else {
                    int pageNum = appearance.getPageNo();
                    if (pageNum == -1) {
                        pageNums = new int[totalPages];
                        for (int i = 1; i <= totalPages; ++i) {
                            pageNums[i - 1] = i;
                        }
                    } else {
                        ParamCheckUtil.checkPageNum(pageNum, totalPages);
                        pageNums = new int[]{pageNum};
                    }
                }
                keywordList = parser.locationExtraction(filesMap, keyword, pageNums);
            } else {
                for (int i = 0; i < pageNums.length; ++i) {
                    ParamCheckUtil.checkPageNum(pageNums[i], totalPages);
                }
                keywordList = parser.locationExtraction(filesMap, keyword, pageNums);
            }
            if (null != keywordList && !keywordList.isEmpty()) {
                if (keywordIndex == -1) {
                    appearance.setKeywordLocationList(keywordList);
                } else {
                    Rectangle rect = null;
                    if (keywordIndex <= 0 || keywordList.size() < keywordIndex) {
                        throw new SealException("keywordIndex=" + keywordIndex + " is not exists!");
                    }
                    rect = keywordList.get(keywordIndex - 1);
                    ArrayList<Rectangle> tmpKeywordList = new ArrayList<Rectangle>();
                    tmpKeywordList.add(rect);
                    appearance.setKeywordLocationList(tmpKeywordList);
                }
            } else {
                throw new Exception("keyword =" + keyword + " not found in pageNum=" + Arrays.toString(pageNums) + " keywordIndex=" + keywordIndex);
            }
            parser.destroy();
            SealResultInfo sealResultInfo = SignatureUtil.p1Sign(filesMap, eSseal, appearance, signInfo);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signKeyword failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signKeyword failed:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        finally {
            parser.destroy();
            parser = null;
            ofdInputStream.close();
        }
    }

    private static SealResultInfo p1Sign(Map<String, byte[]> filesMap, SESeal eSseal, SignAppearance appearance, SignInfoConfig signInfo) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("p1Sign start...");
        if (null == appearance) {
            throw new IllegalArgumentException("appearance is null!");
        }
        if (null == signInfo) {
            throw new IllegalArgumentException("signInfo is null!");
        }
        Mechanism signAlg = signInfo.getSignAlg();
        if (null == signAlg) {
            throw new IllegalArgumentException("signAlg is null!");
        }
        X509Cert signCert = signInfo.getSignCert();
        if (null == signCert) {
            throw new IllegalArgumentException("signCert is null!");
        }
        ParamCheckUtil.checkCertValidity(signCert, -1);
        if (null == eSseal) {
            eSseal = SignatureUtil.makeSeal(appearance, signInfo);
        }
        SealResultInfo sealResult = new SealResultInfo();
        try {
            SealCheckUtil.checkSeal(eSseal, signCert, new Date(), -1);
            SealCheckUtil.checkSealVersion(eSseal, signInfo.getSpecification());
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            byte[] signaturesData = filesMap.get(baseDir + "Signatures.xml");
            String signaturesFileName = "Signatures.xml";
            if (null == signaturesData) {
                signaturesFileName = "Signs/Signatures.xml";
                signaturesData = filesMap.get(baseDir + signaturesFileName);
            }
            String newSignDir = "Signs/Sign_";
            String signID = null;
            if (null == signaturesData) {
                SealXMLUtil.updateOFD(filesMap, "OFD.xml", baseDir + "Signatures.xml");
                signID = SealXMLUtil.generateSiangtures(filesMap, baseDir, "Signatures.xml", newSignDir, "Signature.xml");
            } else {
                signID = SealXMLUtil.updateSignatures(filesMap, baseDir, signaturesFileName, newSignDir, "Signature.xml");
            }
            appearance.setId(String.valueOf(Integer.parseInt(signID) + 2));
            Date signDate = new Date();
            signDate = DateUtil.addDate(signDate, DateUtil.DateType.SS, SysEnv.getSignTimeOffset());
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            int spec = signInfo.getSpecification();
            if (spec == 3 || spec == -1 && SysEnv.isForTax()) {
                TaxUtil.addVerifyArea(filesMap, root, baseDir, appearance, signDate);
            } else {
                filesMap.put(baseDir + newSignDir + signID + "/" + "Seal.esl", eSseal.getEncoded());
            }
            HashMap<String, String> signatureMap = SealXMLUtil.generateSignature(filesMap, root, signAlg, eSseal, signInfo, appearance, baseDir, newSignDir + signID + "/", "Signature.xml", "SignedValue.dat", signDate);
            String signDatasPath = signatureMap.get("signaturePath");
            byte[] signDatas = filesMap.get(signDatasPath);
            byte[] sourceHash = FileHashUtil.calculateHash(signDatas, signAlg, null);
            String sourceProperty = signatureMap.get("sourceProperty");
            List<byte[]> signResultList = OFDSignatureUtil.sign(sourceHash, sourceProperty, eSseal, signDate, signInfo);
            byte[] signedData = signResultList.get(0);
            if (signInfo.isAsyn()) {
                byte[] hashData = signResultList.get(1);
                sealResult.setHashData(hashData);
            }
            signResultList.clear();
            sealResult.setSignID(signID);
            filesMap.put(baseDir + newSignDir + signID + "/" + "SignedValue.dat", signedData);
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            sealResult.setSignedData(newOFDStream.toByteArray());
            sealResult.setSignStatus(true);
            sealResult.setSignedNum(signInfo.getSignedNum());
            SealResultInfo sealResultInfo = sealResult;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("p1Sign failed:", (Throwable)e);
            sealResult.setSignStatus(false);
            sealResult.setFailReason(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            businessLog.error("p1Sign failed:", (Throwable)e);
            sealResult.setSignStatus(false);
            sealResult.setFailReason(e.getMessage());
            throw new SealException("p1Sign failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("p1Sign end...cost= " + (end - start) + " ms");
        }
    }

    public static Session getSession(Session session) {
        if (session == null) {
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                businessLog.error("getSession failed", (Throwable)e);
            }
        }
        return session;
    }

    private static SESeal makeSeal(SignAppearance appearance, SignInfoConfig signInfo) throws SealException {
        SealInfo sealInfo = new SealInfo();
        String sealId = appearance.getSealId();
        String sealName = appearance.getSealName();
        int sealType = appearance.getSealType();
        if (null == sealId) {
            throw new IllegalArgumentException("sealId is null!");
        }
        if (null == sealName) {
            throw new IllegalArgumentException("sealName is null!");
        }
        byte[] imageData = appearance.getImageData();
        if (null == imageData) {
            throw new IllegalArgumentException("imageData is null!");
        }
        String imageType = ImageUtil.getImageType(imageData);
        sealInfo.setEsID(sealId);
        sealInfo.setSealType(sealType);
        sealInfo.setSealName(sealName);
        X509Cert[] certList = new X509Cert[1];
        X509Cert sealMakerSignCert = SysEnv.getSealMakerSignCert();
        if (null == sealMakerSignCert) {
            throw new SealException("sealSigner's signCert is null! invode SysEnv.setSealMakerSignCert() first!");
        }
        ParamCheckUtil.checkCertValidity(sealMakerSignCert, -1);
        X509Cert signCert = signInfo.getSignCert();
        ParamCheckUtil.checkCertValidity(signCert, -1);
        certList[0] = signCert;
        sealInfo.setCertList(certList);
        sealInfo.setValidStart(signCert.getNotBefore());
        sealInfo.setValidEnd(signCert.getNotAfter());
        PrivateKey pk = SysEnv.getSealMakerPrivKey();
        if (null == pk) {
            throw new SealException("sealSigner's privateKey is null!  invode SysEnv.setSealMakerPrivKey() first!");
        }
        sealInfo.setSealSignerPrivateKey(pk);
        sealInfo.setSealSignerCert(sealMakerSignCert);
        sealInfo.setSignAlg(signInfo.getSignAlg());
        sealInfo.setPictureType(imageType);
        sealInfo.setPictureData(imageData);
        sealInfo.setSpecification(signInfo.getSpecification());
        byte[] sealData = MakeSealUtil.makeSeal(sealInfo, SignatureUtil.getSession(null));
        SESeal eSseal = SESeal.getInstance(sealData);
        return eSseal;
    }

    static {
        VersionInfo.environments();
    }
}

