/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.util;

import cfca.sadk.tls.sun.security.util.MemoryCache;
import cfca.sadk.tls.sun.security.util.NullCache;
import cfca.sadk.tls.util.Utilities;
import java.util.Map;

public abstract class CFCACache<K, V> {
    protected CFCACache() {
    }

    public abstract int size();

    public abstract void clear();

    public abstract void put(K var1, V var2);

    public abstract V get(Object var1);

    public abstract void remove(Object var1);

    public abstract void setCapacity(int var1);

    public abstract void setTimeout(int var1);

    public abstract void accept(CacheVisitor<K, V> var1);

    public static <K, V> CFCACache<K, V> newSoftMemoryCache(int size) {
        return new MemoryCache(true, size);
    }

    public static <K, V> CFCACache<K, V> newSoftMemoryCache(int size, int timeout) {
        return new MemoryCache(true, size, timeout);
    }

    public static <K, V> CFCACache<K, V> newHardMemoryCache(int size) {
        return new MemoryCache(false, size);
    }

    public static <K, V> CFCACache<K, V> newNullCache() {
        return NullCache.INSTANCE;
    }

    public static <K, V> CFCACache<K, V> newHardMemoryCache(int size, int timeout) {
        return new MemoryCache(false, size, timeout);
    }

    public static interface CacheVisitor<K, V> {
        public void visit(Map<K, V> var1);
    }

    public static class EqualByteArray {
        private final byte[] b;
        private volatile int hash;

        public EqualByteArray(byte[] b) {
            this.b = b;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.b.length + 1;
                for (int i = 0; i < this.b.length; ++i) {
                    h += (this.b[i] & 0xFF) * 37;
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EqualByteArray)) {
                return false;
            }
            EqualByteArray other = (EqualByteArray)obj;
            return Utilities.equals(this.b, other.b);
        }
    }
}

