/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.core;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat10
extends CMap {
    private final int startCharCode;
    private final int numChars;

    protected CMapFormat10(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format10.value, cmapId);
        this.startCharCode = this.data.readULongAsInt(CMapTable.Offset.format10StartCharCode.offset);
        this.numChars = this.data.readUShort(CMapTable.Offset.format10NumChars.offset);
    }

    @Override
    public int glyphId(int character) {
        if (character < this.startCharCode || character >= this.startCharCode + this.numChars) {
            return 0;
        }
        return this.readFontData().readUShort(character - this.startCharCode);
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format10Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat10> {
        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format10Length.offset)), CMap.CMapFormat.Format10, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format10Length.offset)), CMap.CMapFormat.Format10, cmapId);
        }

        @Override
        protected CMapFormat10 subBuildTable(ReadableFontData data) {
            return new CMapFormat10(data, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int character;

        private CharacterIterator() {
            this.character = CMapFormat10.this.startCharCode;
        }

        @Override
        public boolean hasNext() {
            return this.character < CMapFormat10.this.startCharCode + CMapFormat10.this.numChars;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

