/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.c200.CardKey;

public abstract class SM2CardKey
implements CardKey {
    final byte[] defaultZ;
    final long keyHandle;
    final byte[] pubKeyX;
    final byte[] pubKeyY;
    final String CKID;
    final int keyUsage;
    final boolean internal;

    SM2CardKey(byte[] defaultZ, long keyHandle, byte[] pubKeyX, byte[] pubKeyY, String CKID, int keyUsage) {
        this.defaultZ = defaultZ == null ? new byte[]{} : defaultZ;
        this.keyHandle = keyHandle;
        this.pubKeyX = pubKeyX == null ? new byte[]{} : pubKeyX;
        this.pubKeyY = pubKeyY == null ? new byte[]{} : pubKeyY;
        this.CKID = CKID;
        this.keyUsage = keyUsage;
        this.internal = true;
    }

    SM2CardKey(SM2PublicKey sm2Key) {
        this.defaultZ = sm2Key.getDefaultZ();
        this.keyHandle = -1L;
        this.pubKeyX = sm2Key.getPubX();
        this.pubKeyY = sm2Key.getPubY();
        this.CKID = "external";
        this.keyUsage = 0;
        this.internal = false;
    }

    public final byte[] getDefaultZ() {
        return this.defaultZ;
    }

    public final long getKeyHandle() {
        return this.keyHandle;
    }

    public final String getAlgorithm() {
        return "SM2";
    }

    public final String getFormat() {
        return "SM2Card";
    }

    public byte[] getPubKeyX() {
        return this.pubKeyX;
    }

    public byte[] getPubKeyY() {
        return this.pubKeyY;
    }
}

