/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzV;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DataTable {
    private final DataRowCollection zzY66 = new DataRowCollection(this);
    private final DataColumnCollection zzY65 = new DataColumnCollection(this);
    private final ConstraintCollection zzY64 = new ConstraintCollection(this);
    private final zzV zzY63 = new zzV(this);
    private ResultSet zzY62;
    private String zzZpb;
    private DataSet zzb1;
    private String zzZgx = "";
    private UniqueConstraint zzY61;
    private boolean zzY6d = true;

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZpb = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, DataTable.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzY62 = resultSet;
        this.zzZpb = tableName;
        this.zzYWk();
        this.zzYWj();
    }

    public void close() throws Exception {
        if (this.zzY62 != null) {
            if (this.zzY62.getStatement() != null) {
                this.zzY62.getStatement().getConnection().close();
            }
            this.zzY62 = null;
        }
    }

    public String getTableName() {
        return this.zzZpb;
    }

    public void setTableName(String tableName) {
        this.zzZpb = tableName;
    }

    public boolean containsColumn(String columnName) {
        try {
            this.zzY62.findColumn(columnName);
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public int getColumnsCount() {
        return this.zzY65.getCount();
    }

    public String getColumnName(int index) {
        return this.zzY65.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzY62;
    }

    public DataSet getDataSet() {
        return this.zzb1;
    }

    void zzZ(DataSet dataSet) {
        this.zzb1 = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzY66;
    }

    public DataColumnCollection getColumns() {
        return this.zzY65;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public void loadNewTable(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        this.zzY65.clear();
        this.zzY66.clear();
        this.zzY62 = resultSet;
        this.zzYWk();
        this.zzYWj();
    }

    public ConstraintCollection getConstraints() {
        return this.zzY64;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzY61 == null) {
            return new DataColumn[0];
        }
        return this.zzY61.getColumns();
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzY61 != null) {
                this.zzY61.zzQU(false);
                this.getConstraints().remove(this.zzY61);
                this.zzY61 = null;
            }
            return;
        }
        if (this.zzY61 != null && DataColumn.areColumnSetsTheSame(value, this.zzY61.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzY(this.getConstraints(), value);
        if (null == uniqueConstraint) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzY61 != null) {
            this.zzY61.zzQU(false);
            this.getConstraints().remove(this.zzY61);
            this.zzY61 = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzY61 = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZgx;
    }

    public void setNamespace(String namespace) {
        this.zzZgx = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzY6d;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzY6d = enforceConstraints;
    }

    boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, DataRow dataRow) {
        return zzY.zzZ(this, dataColumnArray, dataColumnArray2, dataRow);
    }

    zzV zzYWl() {
        return this.zzY63;
    }

    private void zzYWk() throws SQLException {
        for (int i = 1; i <= this.zzY62.getMetaData().getColumnCount(); ++i) {
            String string = this.zzY62.getMetaData().getColumnName(i);
            DataColumn dataColumn = new DataColumn(string, this, i);
            this.zzY65.add(dataColumn);
        }
    }

    private void zzYWj() throws SQLException {
        DataRow dataRow;
        if (this.zzY62.getType() != 1003) {
            this.zzY62.beforeFirst();
        }
        while (this.zzY62.next() && (dataRow = new DataRow(this)).readFrom(this.zzY62)) {
            try {
                this.zzY66.add(dataRow);
            }
            catch (InvalidConstraintException invalidConstraintException) {
                invalidConstraintException.printStackTrace();
            }
        }
    }

    private static String zzZ(ResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        try {
            return resultSet.getMetaData().getTableName(1);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

