/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.sm2;

final class TLV {
    int type = -1;
    int vLength = -1;
    int hLength = -1;
    final boolean failure;

    TLV(byte[] data, int offset) {
        if (data == null || data.length < 2 + offset) {
            this.failure = true;
            return;
        }
        this.type = data[offset++] & 0xFF;
        this.hLength = 1;
        this.vLength = data[offset++] & 0xFF;
        ++this.hLength;
        if (this.vLength == 128) {
            this.failure = true;
            return;
        }
        if (this.vLength > 127) {
            int size = this.vLength & 0x7F;
            if (size > 4) {
                this.failure = true;
                return;
            }
            if (data.length < offset + size) {
                this.failure = true;
                return;
            }
            this.hLength += size;
            this.vLength = 0;
            int next = 0;
            for (int i = 0; i < size; ++i) {
                next = data[offset++] & 0xFF;
                this.vLength = (this.vLength << 8) + next;
            }
            if (this.vLength < 0) {
                this.failure = true;
                return;
            }
        }
        if (data.length < offset + this.vLength) {
            this.failure = true;
            return;
        }
        this.failure = false;
    }
}

