/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.forms;

import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPageFormCopier
implements IPdfPageExtraCopier {
    PdfAcroForm formFrom;
    PdfAcroForm formTo;
    PdfDocument documentFrom;
    PdfDocument documentTo;
    Logger logger = LoggerFactory.getLogger(PdfPageFormCopier.class);

    @Override
    public void copy(PdfPage fromPage, PdfPage toPage) {
        Map<String, PdfFormField> fieldsFrom;
        if (this.documentFrom != fromPage.getDocument()) {
            this.documentFrom = fromPage.getDocument();
            this.formFrom = PdfAcroForm.getAcroForm(this.documentFrom, false);
        }
        if (this.documentTo != toPage.getDocument()) {
            this.documentTo = toPage.getDocument();
            this.formTo = PdfAcroForm.getAcroForm(this.documentTo, true);
        }
        if (this.formFrom != null) {
            ArrayList<PdfName> excludedKeys = new ArrayList<PdfName>();
            excludedKeys.add(PdfName.Fields);
            excludedKeys.add(PdfName.DR);
            PdfDictionary dict = ((PdfDictionary)this.formFrom.getPdfObject()).copyTo(this.documentTo, excludedKeys, false);
            ((PdfDictionary)this.formTo.getPdfObject()).mergeDifferent(dict);
        }
        if (this.formFrom != null && (fieldsFrom = this.formFrom.getFormFields()).size() > 0) {
            Map<String, PdfFormField> fieldsTo = this.formTo.getFormFields();
            List<PdfAnnotation> annots = toPage.getAnnotations();
            for (PdfAnnotation annot : annots) {
                PdfFormField field;
                if (!annot.getSubtype().equals(PdfName.Widget)) continue;
                PdfDictionary parent = ((PdfDictionary)annot.getPdfObject()).getAsDictionary(PdfName.Parent);
                if (parent != null) {
                    PdfFormField parentField = this.getParentField(parent, this.documentTo);
                    PdfString parentName = parentField.getFieldName();
                    if (parentName == null) continue;
                    if (!fieldsTo.containsKey(parentName.toUnicodeString())) {
                        field = this.createParentFieldCopy((PdfDictionary)annot.getPdfObject(), this.documentTo);
                        PdfArray kids = field.getKids();
                        ((PdfDictionary)field.getPdfObject()).remove(PdfName.Kids);
                        this.formTo.addField(field, toPage);
                        ((PdfDictionary)field.getPdfObject()).put(PdfName.Kids, kids);
                        continue;
                    }
                    field = PdfFormField.makeFormField(annot.getPdfObject(), this.documentTo);
                    PdfString fieldName = field.getFieldName();
                    if (fieldName != null) {
                        PdfFormField existingField = fieldsTo.get(fieldName.toUnicodeString());
                        if (existingField != null) {
                            PdfFormField clonedField = PdfFormField.makeFormField(((PdfDictionary)field.getPdfObject()).clone().makeIndirect(this.documentTo), this.documentTo);
                            ((PdfDictionary)toPage.getPdfObject()).getAsArray(PdfName.Annots).add((PdfObject)clonedField.getPdfObject());
                            toPage.removeAnnotation(annot);
                            this.mergeFieldsWithTheSameName(clonedField);
                            continue;
                        }
                        HashSet<String> existingFields = new HashSet<String>();
                        this.getAllFieldNames(this.formTo.getFields(), existingFields);
                        this.addChildToExistingParent((PdfDictionary)annot.getPdfObject(), existingFields);
                        continue;
                    }
                    if (parentField.getKids().contains((PdfObject)field.getPdfObject())) continue;
                    HashSet<String> existingFields = new HashSet<String>();
                    this.getAllFieldNames(this.formTo.getFields(), existingFields);
                    this.addChildToExistingParent((PdfDictionary)annot.getPdfObject(), existingFields);
                    continue;
                }
                PdfString annotName = ((PdfDictionary)annot.getPdfObject()).getAsString(PdfName.T);
                String annotNameString = null;
                if (annotName != null) {
                    annotNameString = annotName.toUnicodeString();
                }
                if (annotNameString == null || !fieldsFrom.containsKey(annotNameString)) continue;
                field = fieldsTo.get(annotNameString);
                if (field != null) {
                    PdfDictionary clonedAnnot = (PdfDictionary)((PdfDictionary)annot.getPdfObject()).clone().makeIndirect(this.documentTo);
                    ((PdfDictionary)toPage.getPdfObject()).getAsArray(PdfName.Annots).add(clonedAnnot);
                    toPage.removeAnnotation(annot);
                    field = this.mergeFieldsWithTheSameName(PdfFormField.makeFormField(clonedAnnot, toPage.getDocument()));
                    this.logger.warn(MessageFormatUtil.format("The document already has field {0}. Annotations of the fields with this name will be added to the existing one as children. If you want to have separate fields, please, rename them manually before copying.", annotNameString));
                    PdfArray kids = field.getKids();
                    if (kids != null) {
                        ((PdfDictionary)field.getPdfObject()).remove(PdfName.Kids);
                        this.formTo.addField(field, toPage);
                        ((PdfDictionary)field.getPdfObject()).put(PdfName.Kids, kids);
                        continue;
                    }
                    this.formTo.addField(field, toPage);
                    continue;
                }
                this.formTo.addField(PdfFormField.makeFormField(annot.getPdfObject(), this.documentTo), null);
            }
        }
    }

    private PdfFormField mergeFieldsWithTheSameName(PdfFormField newField) {
        String fullFieldName = newField.getFieldName().toUnicodeString();
        PdfString fieldName = ((PdfDictionary)newField.getPdfObject()).getAsString(PdfName.T);
        PdfFormField existingField = this.formTo.getField(fullFieldName);
        if (existingField.isFlushed()) {
            int index = 0;
            do {
                newField.setFieldName(fieldName.toUnicodeString() + "_#" + ++index);
            } while (this.formTo.getField(fullFieldName = newField.getFieldName().toUnicodeString()) != null);
            return newField;
        }
        ((PdfDictionary)newField.getPdfObject()).remove(PdfName.T);
        ((PdfDictionary)newField.getPdfObject()).remove(PdfName.P);
        PdfArray kids = existingField.getKids();
        if (kids != null && !kids.isEmpty()) {
            existingField.addKid(newField);
            return existingField;
        }
        ((PdfDictionary)existingField.getPdfObject()).remove(PdfName.T);
        ((PdfDictionary)existingField.getPdfObject()).remove(PdfName.P);
        this.formTo.getFields().remove((PdfObject)existingField.getPdfObject());
        PdfFormField mergedField = PdfFormField.createEmptyField(this.documentTo);
        mergedField.put(PdfName.FT, existingField.getFormType()).put(PdfName.T, fieldName);
        PdfDictionary parent = existingField.getParent();
        if (parent != null) {
            mergedField.put(PdfName.Parent, parent);
            PdfArray parentKids = parent.getAsArray(PdfName.Kids);
            for (int i = 0; i < parentKids.size(); ++i) {
                PdfObject obj = parentKids.get(i);
                if (obj != existingField.getPdfObject()) continue;
                parentKids.set(i, (PdfObject)mergedField.getPdfObject());
                break;
            }
        }
        if ((kids = existingField.getKids()) != null) {
            mergedField.put(PdfName.Kids, kids);
        }
        mergedField.addKid(existingField).addKid(newField);
        PdfObject value = existingField.getValue();
        if (value != null) {
            mergedField.put(PdfName.V, ((PdfDictionary)existingField.getPdfObject()).get(PdfName.V));
        }
        return mergedField;
    }

    private PdfFormField getParentField(PdfDictionary parent, PdfDocument pdfDoc) {
        PdfFormField parentField = PdfFormField.makeFormField(parent, pdfDoc);
        PdfDictionary parentOfParent = parentField.getParent();
        if (parentOfParent != null) {
            parentField = this.getParentField(parentOfParent, pdfDoc);
        }
        return parentField;
    }

    private PdfFormField createParentFieldCopy(PdfDictionary fieldDic, PdfDocument pdfDoc) {
        fieldDic.remove(PdfName.Kids);
        PdfDictionary parent = fieldDic.getAsDictionary(PdfName.Parent);
        PdfFormField field = PdfFormField.makeFormField(fieldDic, pdfDoc);
        if (parent != null) {
            field = this.createParentFieldCopy(parent, pdfDoc);
            parent.put(PdfName.Kids, new PdfArray(fieldDic));
        }
        return field;
    }

    private void addChildToExistingParent(PdfDictionary fieldDic, Set<String> existingFields) {
        PdfDictionary parent = fieldDic.getAsDictionary(PdfName.Parent);
        PdfString parentName = parent.getAsString(PdfName.T);
        if (parentName != null) {
            String name = parentName.toUnicodeString();
            if (existingFields.contains(name)) {
                PdfArray kids = parent.getAsArray(PdfName.Kids);
                kids.add(fieldDic);
            } else {
                parent.put(PdfName.Kids, new PdfArray(fieldDic));
                this.addChildToExistingParent(parent, existingFields);
            }
        }
    }

    private void getAllFieldNames(PdfArray fields, Set<String> existingFields) {
        for (PdfObject field : fields) {
            PdfArray kids;
            if (field.isFlushed()) continue;
            PdfDictionary dic = (PdfDictionary)field;
            PdfString name = dic.getAsString(PdfName.T);
            if (name != null) {
                existingFields.add(name.toUnicodeString());
            }
            if ((kids = dic.getAsArray(PdfName.Kids)) == null) continue;
            this.getAllFieldNames(kids, existingFields);
        }
    }
}

