/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.ofd.base.asn1.SES_Signature;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.asn1.TBS_Sign;
import cfca.sadk.ofd.base.common.Dom4jUtil;
import cfca.sadk.ofd.base.common.FileHashUtil;
import cfca.sadk.ofd.base.common.MechanismUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.seal.OFDSignatureUtil;
import cfca.sadk.ofd.base.seal.SealCheckUtil;
import cfca.sadk.ofd.base.seal.SealVerifyResult;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import cfca.sadk.ofd.base.seal.VerifyInfo;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;

public class VerifyUtil {
    private static Logger businessLog = LoggerFactory.getLogger(VerifyUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SealVerifyResult verify(InputStream ofdInputStream, int verifyLevel) throws SealException {
        SealVerifyResult sealVerifyResult;
        long start = System.currentTimeMillis();
        businessLog.info("verify start...");
        SealVerifyResult sealVerifyResult2 = new SealVerifyResult();
        HashMap<String, VerifyInfo> resultMap = sealVerifyResult2.getVerifyInfos();
        String failReason = "";
        Map<String, byte[]> filesMap = null;
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInputStream is null!");
        }
        HashMap<String, String> cacheHashMap = new HashMap<String, String>();
        try {
            filesMap = ZipUtil.uncompress(ofdInputStream);
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            String signaturesName = baseDir + "Signatures.xml";
            if (null == filesMap.get(signaturesName)) {
                boolean noSig = true;
                Set<String> files = filesMap.keySet();
                for (String string : files) {
                    if (!string.endsWith("Signatures.xml")) continue;
                    noSig = false;
                    break;
                }
                if (noSig) {
                    failReason = "no signature found!";
                    sealVerifyResult2.setFailReason(failReason);
                    sealVerifyResult2.setFailType(1);
                    VerifyUtil.checkResult(sealVerifyResult2);
                    SealVerifyResult sealVerifyResult3 = sealVerifyResult2;
                    return sealVerifyResult3;
                }
            }
            Iterator<String> iterator = filesMap.keySet().iterator();
            boolean isFailed = true;
            while (iterator.hasNext()) {
                byte[] fileData;
                SealVerifyResult verifyResult;
                String fileName = iterator.next();
                if (!fileName.startsWith(baseDir + "Signs/Sign_") || !fileName.endsWith("Signature.xml")) continue;
                isFailed = false;
                byte[] byArray = filesMap.get(fileName);
                Document signatureFile = Dom4jUtil.parseFile(new ByteArrayInputStream(byArray));
                Element body = signatureFile.getRootElement();
                Element signedInfo = body.element("SignedInfo");
                HashMap<String, Object> signatureListFileMap = new HashMap<String, Object>();
                VerifyInfo verifyInfo = new VerifyInfo();
                String signedValueFileName = body.element("SignedValue").getText();
                if (!signedValueFileName.contains("/")) {
                    signedValueFileName = fileName.replace("Signature.xml", signedValueFileName);
                } else if (signedValueFileName.startsWith("/")) {
                    signedValueFileName = signedValueFileName.substring(1);
                }
                byte[] signedValue = filesMap.get(signedValueFileName);
                SES_Signature sesSign = SES_Signature.getInstance(signedValue);
                TBS_Sign toSign = sesSign.getToSign();
                ASN1OctetString signCertOctet = sesSign.getCert();
                X509Cert signCert = new X509Cert(signCertOctet.getOctets());
                SESeal eSseal = toSign.getEseal();
                ASN1ObjectIdentifier signAlg = sesSign.getSignatureAlgorithm();
                String signAlgString = Mechanism.getSignatureAlgName((AlgorithmIdentifier)new AlgorithmIdentifier(signAlg));
                DERIA5String propertyInfo = toSign.getPropertyInfo();
                String property = propertyInfo.getString();
                int endIndex = property.lastIndexOf("}");
                String filePath = null;
                if (endIndex != -1) {
                    property = property.substring(0, endIndex + 1);
                    Gson gson = new Gson();
                    HashMap map = (HashMap)gson.fromJson(property, HashMap.class);
                    filePath = (String)map.get("Entry");
                } else {
                    filePath = property.toString();
                }
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                if (!(verifyResult = OFDSignatureUtil.verify(fileData = filesMap.get(filePath), signedValue, verifyLevel)).getVerifyResult()) {
                    SealVerifyResult sealVerifyResult4 = verifyResult;
                    return sealVerifyResult4;
                }
                SealCheckUtil.checkSeal(eSseal, signCert, verifyResult.getSignTime(), verifyLevel);
                Element references = signedInfo.element("References");
                String degistOID = references.attributeValue("CheckMethod");
                Mechanism refDigestAlg = MechanismUtil.getMechanism(degistOID);
                List referenceList = references.elements("Reference");
                for (int i = 0; i < referenceList.size(); ++i) {
                    Element oneRef = (Element)referenceList.get(i);
                    String filePathName = oneRef.attributeValue("FileRef");
                    String originHashValue = oneRef.element("CheckValue").getStringValue();
                    String singleFileName = null;
                    singleFileName = filePathName.startsWith("/") ? filePathName.substring(1) : filePathName;
                    if (null == cacheHashMap.get(singleFileName)) {
                        byte[] singleFileData = filesMap.get(singleFileName);
                        String hashValue = null;
                        if (null == singleFileData) {
                            businessLog.error("fileData is null,filename is:" + singleFileName);
                            throw new SealException("fileData is null,filename is:" + singleFileName);
                        }
                        if (singleFileData.length == 0) {
                            hashValue = "";
                        } else {
                            byte[] currentHash = FileHashUtil.calculateHash(singleFileData, refDigestAlg, null);
                            hashValue = new String(Base64.encode((byte[])currentHash), "UTF-8");
                        }
                        if (!originHashValue.equals(hashValue)) {
                            failReason = "file=" + singleFileName + " is changed!";
                            sealVerifyResult2.setFailReason(failReason);
                            sealVerifyResult2.setFailType(7);
                            VerifyUtil.checkResult(sealVerifyResult2);
                            SealVerifyResult sealVerifyResult5 = sealVerifyResult2;
                            return sealVerifyResult5;
                        }
                        cacheHashMap.put(singleFileName, hashValue);
                    }
                    signatureListFileMap.put(singleFileName, null);
                }
                verifyInfo.setSeal(eSseal);
                verifyInfo.setSignTime(verifyResult.getSignTime());
                verifyInfo.setX509Cert(signCert);
                verifyInfo.setSignatureName(fileName);
                verifyInfo.setSignAlg(signAlgString);
                resultMap.put(fileName, verifyInfo);
            }
            if (!isFailed) {
                sealVerifyResult2.setVerifyResult(true);
            } else {
                sealVerifyResult2.setFailReason("process failed,please check the file!");
                sealVerifyResult2.setFailType(-1);
            }
            SealVerifyResult sealVerifyResult5 = sealVerifyResult2;
            return sealVerifyResult5;
        }
        catch (SealException e) {
            businessLog.error("verify failed:", (Throwable)e);
            sealVerifyResult2.setFailReason(e.getMessage());
            if (e.getMessage().contains("keyUsage not contain digitalSignature")) {
                sealVerifyResult2.setFailType(5);
            } else if (e.getMessage().contains("x509Cert is not trusted")) {
                sealVerifyResult2.setFailType(3);
            } else if (e.getMessage().contains("x509Cert is revoked")) {
                sealVerifyResult2.setFailType(4);
            } else {
                sealVerifyResult2.setFailType(-1);
            }
            if (SysEnv.isVerifyFailedThrowException()) {
                throw e;
            }
            sealVerifyResult = sealVerifyResult2;
            return sealVerifyResult;
        }
        catch (Exception e) {
            businessLog.error("verify failed:", (Throwable)e);
            sealVerifyResult2.setFailReason(e.getMessage());
            sealVerifyResult2.setFailType(-1);
            if (SysEnv.isVerifyFailedThrowException()) {
                throw new SealException("verify failed:", e);
            }
            sealVerifyResult = sealVerifyResult2;
            return sealVerifyResult;
        }
        finally {
            cacheHashMap.clear();
            cacheHashMap = null;
            filesMap = null;
            long end = System.currentTimeMillis();
            businessLog.info("verify end...cost= " + (end - start) + " ms");
        }
    }

    public static SealVerifyResult verify(byte[] ofdDatas, int verifyLevel) throws SealException {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        return VerifyUtil.verify(new ByteArrayInputStream(ofdDatas), verifyLevel);
    }

    private static void checkResult(SealVerifyResult verifyResult) throws SealException {
        if (!verifyResult.getVerifyResult() && SysEnv.isVerifyFailedThrowException()) {
            throw new SealException(verifyResult.getFailReason());
        }
    }

    static {
        VersionInfo.environments();
    }

    public static interface VerifyFailType {
        public static final int NoSignatureFound = 1;
        public static final int VerifySignatureFail = 2;
        public static final int VerifyCertChainFail = 3;
        public static final int VerifyCRLFail = 4;
        public static final int VerifyKeyUsageFail = 5;
        public static final int VerifyHashFail = 6;
        public static final int VerifyOriginHashFail = 7;
        public static final int FileNotProtected = 8;
        public static final int SignTimeAfterTSATime = 9;
        public static final int OFDProcessError = -1;
    }

    public static interface VerifyLevel {
        public static final int verifySignature = 1;
        public static final int verifyCertChain = 2;
        public static final int verifyCRL = 4;
        public static final int verifyKeyUsage = 8;
    }
}

