/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.path.impl;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Point;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;

public class LineTo
extends AbstractPathShape {
    static final int ARGUMENT_SIZE = 2;

    public LineTo() {
        this(false);
    }

    public LineTo(boolean relative) {
        super(relative);
    }

    @Override
    public void draw(PdfCanvas canvas) {
        float x = CssUtils.parseAbsoluteLength(this.coordinates[0]);
        float y = CssUtils.parseAbsoluteLength(this.coordinates[1]);
        canvas.lineTo(x, y);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length != 2) {
            throw new IllegalArgumentException(MessageFormatUtil.format("(x y)+ parameters are expected for lineTo operator. Got: {0}", Arrays.toString(inputCoordinates)));
        }
        this.coordinates = new String[]{inputCoordinates[0], inputCoordinates[1]};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, new double[]{startPoint.x, startPoint.y});
        }
    }
}

