/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.x509.certificate.X509CRL;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertVerifyUtil {
    private static final Logger sysLog = LoggerFactory.getLogger(CertVerifyUtil.class);
    public static final int CERT_OUT_OF_DATE = 1;
    public static final int CERT_INVALID = 2;
    public static final int CERT_VALID = 0;

    public static int verifyCertDate(X509Cert cert) {
        Date notAfter = cert.getNotAfter();
        Date notBefore = cert.getNotBefore();
        Date today = new Date();
        if (notAfter.before(today)) {
            sysLog.error("preCert has expired.");
            return 1;
        }
        if (notBefore.after(today)) {
            sysLog.error("preCert is unvalid.");
            return 2;
        }
        return 0;
    }

    public static boolean verifyCertDate(X509Cert signCert, Date date) {
        Date notBefore = signCert.getNotBefore();
        Date notAfter = signCert.getNotAfter();
        return date.after(notBefore) && date.before(notAfter);
    }

    public static boolean verifyCertSign(X509Cert x509Cert) throws CodeException {
        try {
            return X509CertVerifier.validateCertSign((X509Cert)x509Cert);
        }
        catch (Exception e) {
            throw new CodeException("600619", "x509Cert verify error: " + x509Cert.getSubject(), (Throwable)e);
        }
    }

    public static boolean verifyCertSign(List<X509Cert> x509Certs) {
        boolean verify = true;
        try {
            for (X509Cert x509Cert : x509Certs) {
                if (verify = verify && X509CertVerifier.validateCertSign((X509Cert)x509Cert)) continue;
                break;
            }
        }
        catch (PKIException e) {
            verify = false;
        }
        return verify;
    }

    public static boolean verifyByCRL(X509Cert userCert, X509CRL x509crl) {
        String certsNum = userCert.getSerialNumber().toString();
        return x509crl.isRevoke(certsNum);
    }
}

