/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import java.io.IOException;

public final class FastBase64 {
    private static final byte[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;
    private static final boolean[] SKIPPING_TABLE;
    private static byte padding;

    private FastBase64() {
    }

    public static final byte[] encode(byte[] data) {
        int a2;
        int a1;
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        byte[] out = new byte[(data.length + 2) / 3 * 4];
        int remain = data.length % 3;
        int dataLength = data.length - remain;
        int ipx = 0;
        int opx = 0;
        while (ipx < dataLength) {
            a1 = 0xFF & data[ipx++];
            a2 = 0xFF & data[ipx++];
            int a3 = 0xFF & data[ipx++];
            out[opx++] = ENCODING_TABLE[0x3F & a1 >>> 2];
            out[opx++] = ENCODING_TABLE[0x3F & (a1 << 4 | a2 >>> 4)];
            out[opx++] = ENCODING_TABLE[0x3F & (a2 << 2 | a3 >>> 6)];
            out[opx++] = ENCODING_TABLE[0x3F & a3];
        }
        switch (remain) {
            case 0: {
                break;
            }
            case 1: {
                a1 = 0xFF & data[ipx++];
                out[opx++] = ENCODING_TABLE[0x3F & a1 >>> 2];
                out[opx++] = ENCODING_TABLE[0x3F & a1 << 4];
                out[opx++] = padding;
                out[opx++] = padding;
                break;
            }
            case 2: {
                a1 = 0xFF & data[ipx++];
                a2 = 0xFF & data[ipx++];
                out[opx++] = ENCODING_TABLE[0x3F & a1 >>> 2];
                out[opx++] = ENCODING_TABLE[0x3F & (a1 << 4 | a2 >>> 4)];
                out[opx++] = ENCODING_TABLE[0x3F & a2 << 2];
                out[opx++] = padding;
                break;
            }
        }
        return out;
    }

    public static final byte[] decode(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        LastBlock lastBlock = FastBase64.findLastBlock(data);
        int finish = lastBlock.finish;
        byte[] buffer = new byte[(data.length * 3 + 3) / 4];
        int ipx = 0;
        int opx = 0;
        ipx = FastBase64.nextI(data, ipx, finish);
        while (ipx < finish) {
            byte b4;
            byte b1 = DECODING_TABLE[data[ipx++]];
            ipx = FastBase64.nextI(data, ipx, finish);
            byte b2 = DECODING_TABLE[data[ipx++]];
            ipx = FastBase64.nextI(data, ipx, finish);
            byte b3 = DECODING_TABLE[data[ipx++]];
            ipx = FastBase64.nextI(data, ipx, finish);
            if ((b1 | b2 | b3 | (b4 = DECODING_TABLE[data[ipx++]])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            buffer[opx++] = (byte)(b1 << 2 | b2 >> 4);
            buffer[opx++] = (byte)(b2 << 4 | b3 >> 2);
            buffer[opx++] = (byte)(b3 << 6 | b4);
            ipx = FastBase64.nextI(data, ipx, finish);
        }
        opx += FastBase64.decodeLastBlock(buffer, opx, lastBlock.c1, lastBlock.c2, lastBlock.c3, lastBlock.c4);
        byte[] out = new byte[opx];
        System.arraycopy(buffer, 0, out, 0, out.length);
        return out;
    }

    private static int decodeLastBlock(byte[] out, int opx, int c1, int c2, int c3, int c4) throws IOException {
        if (c3 == padding) {
            byte b1 = DECODING_TABLE[c1];
            byte b2 = DECODING_TABLE[c2];
            if ((b1 | b2) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            out[opx++] = (byte)(b1 << 2 | b2 >>> 4);
            return 1;
        }
        if (c4 == padding) {
            byte b1 = DECODING_TABLE[c1];
            byte b2 = DECODING_TABLE[c2];
            byte b3 = DECODING_TABLE[c3];
            if ((b1 | b2 | b3) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            out[opx++] = (byte)(b1 << 2 | b2 >>> 4);
            out[opx++] = (byte)(b2 << 4 | b3 >>> 2);
            return 2;
        }
        byte b1 = DECODING_TABLE[c1];
        byte b2 = DECODING_TABLE[c2];
        byte b3 = DECODING_TABLE[c3];
        byte b4 = DECODING_TABLE[c4];
        if ((b1 | b2 | b3 | b4) < 0) {
            throw new IOException("invalid characters encountered at end of base64 data");
        }
        out[opx++] = (byte)(b1 << 2 | b2 >>> 4);
        out[opx++] = (byte)(b2 << 4 | b3 >>> 2);
        out[opx++] = (byte)(b3 << 6 | b4);
        return 3;
    }

    private static int nextI(byte[] data, int ipx, int finish) throws IOException {
        while (ipx < finish && SKIPPING_TABLE[data[ipx]]) {
            ++ipx;
        }
        return ipx;
    }

    private static LastBlock findLastBlock(byte[] data) throws IOException {
        int end;
        for (end = data.length; end > 0 && SKIPPING_TABLE[data[end - 1]]; --end) {
        }
        int[] lastBlock = new int[4];
        int num = 0;
        int value = 0;
        --end;
        while (end >= 0 && num < 4) {
            value = 0xFF & data[end];
            if (SKIPPING_TABLE[value]) {
                --end;
                continue;
            }
            if (value == 61 || DECODING_TABLE[value] >= 0) {
                lastBlock[num++] = (byte)value;
                --end;
                continue;
            }
            throw new IOException("invalid characters encountered in base64 data: " + value);
        }
        return new LastBlock(lastBlock, ++end);
    }

    static {
        int i;
        int c;
        ENCODING_TABLE = new byte[64];
        DECODING_TABLE = new byte[256];
        SKIPPING_TABLE = new boolean[256];
        padding = (byte)61;
        int ipx = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            FastBase64.ENCODING_TABLE[ipx++] = (byte)c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            FastBase64.ENCODING_TABLE[ipx++] = (byte)c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            FastBase64.ENCODING_TABLE[ipx++] = (byte)c;
        }
        FastBase64.ENCODING_TABLE[ipx++] = 43;
        FastBase64.ENCODING_TABLE[ipx++] = 47;
        for (i = 0; i < DECODING_TABLE.length; ++i) {
            FastBase64.DECODING_TABLE[i] = -1;
        }
        for (i = 0; i < ENCODING_TABLE.length; ++i) {
            FastBase64.DECODING_TABLE[FastBase64.ENCODING_TABLE[i]] = (byte)i;
        }
        for (i = 0; i < SKIPPING_TABLE.length; ++i) {
            FastBase64.SKIPPING_TABLE[i] = false;
        }
        FastBase64.SKIPPING_TABLE[10] = true;
        FastBase64.SKIPPING_TABLE[13] = true;
        FastBase64.SKIPPING_TABLE[9] = true;
        FastBase64.SKIPPING_TABLE[32] = true;
    }

    private static class LastBlock {
        final int c1;
        final int c2;
        final int c3;
        final int c4;
        final int finish;

        LastBlock(int[] lastBlock, int finish) {
            this.finish = finish;
            this.c4 = lastBlock[0];
            this.c3 = lastBlock[1];
            this.c2 = lastBlock[2];
            this.c1 = lastBlock[3];
        }
    }
}

