/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IoUtil {
    public static void write(String filePath, byte[] data) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(filePath);
        ((OutputStream)outputStream).write(data);
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    public static byte[] addLength(byte[] bytes) {
        int totalLength = bytes.length + 4;
        byte[] lengthedArray = new byte[totalLength];
        System.arraycopy(IoUtil.intToByteArray(bytes.length), 0, lengthedArray, 0, 4);
        System.arraycopy(bytes, 0, lengthedArray, 4, bytes.length);
        return lengthedArray;
    }

    public static byte[] readLengthValue(InputStream inputStream) throws IOException {
        int receiveLength = IoUtil.readInt(inputStream);
        int bufferSize = receiveLength < 4096 ? receiveLength : 4096;
        byte[] read = IoUtil.read(inputStream, receiveLength, bufferSize);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int num = inputStream.read(buffer);
            while (num != -1) {
                baos.write(buffer, 0, num);
                num = inputStream.read(buffer);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static byte[] read(InputStream inputStream, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int num = inputStream.read(buffer);
        while (num != -1) {
            baos.write(buffer, 0, num);
            num = inputStream.read(buffer);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static void sendLengthValue(OutputStream outputStream, byte[] sendBytes) throws IOException {
        outputStream.write(IoUtil.addLength(sendBytes));
        outputStream.flush();
    }

    public static byte[] read(InputStream inputStream, int length, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int totalNum = 0;
        int num = 0;
        int readLength = bufferSize;
        while (totalNum < length && (num = inputStream.read(buffer, 0, readLength)) > 0) {
            baos.write(buffer, 0, num);
            readLength = length - (totalNum += num) > bufferSize ? bufferSize : length - totalNum;
        }
        baos.flush();
        byte[] result = baos.toByteArray();
        if (result.length != length) {
            throw new IOException("read bytes length is not corrent");
        }
        return baos.toByteArray();
    }

    public static byte[] intToByteArray(int i) {
        byte[] intBytes = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return intBytes;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = inputStream.read();
        if ((ch1 | (ch2 = inputStream.read()) | (ch3 = inputStream.read()) | (ch4 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static Socket createSocket(String host, int port, int connectTimeout, int readTimeout) throws IOException {
        Socket socket = new Socket();
        socket.setReuseAddress(true);
        socket.setSoLinger(true, 0);
        if (readTimeout > 0) {
            socket.setSoTimeout(readTimeout);
        }
        socket.connect(new InetSocketAddress(host, port), connectTimeout);
        return socket;
    }

    public static String getFileNameSuffix(String filePath) {
        int sep = filePath.lastIndexOf(".");
        if (sep != -1) {
            return filePath.substring(sep + 1);
        }
        return filePath;
    }

    public static void toZip(File sourceFile, OutputStream out) throws Exception {
        ZipOutputStream zos = null;
        File[] srcFiles = sourceFile.listFiles();
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[1048];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    throw new IOException();
                }
            }
        }
    }

    private static ZipFile getZipFile(File zipFile, String sysEncodeString) throws Exception {
        ZipFile zip = new ZipFile(zipFile, Charset.forName("GBK"));
        Enumeration<? extends ZipEntry> entries = zip.entries();
        if (entries.hasMoreElements()) {
            try {
                entries.nextElement();
                zip.close();
                zip = new ZipFile(zipFile, Charset.forName("GBK"));
                return zip;
            }
            catch (Exception e) {
                zip = new ZipFile(zipFile, Charset.forName("UTF-8"));
                return zip;
            }
        }
        return zip;
    }

    public static void unZip(String inputFile, String destDirPath) throws Exception {
        File srcFile = new File(inputFile);
        if (!srcFile.exists()) {
            throw new Exception(srcFile.getPath() + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String sysEncodeString = System.getProperty("sun.jnu.encoding");
        System.setProperty("sun.zip.encoding", sysEncodeString);
        ZipFile zipFile = IoUtil.getZipFile(srcFile, sysEncodeString);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                String dirPath = destDirPath + "/" + entry.getName();
                srcFile.mkdirs();
                destDirPath = dirPath;
                continue;
            }
            File targetFile = new File(destDirPath + "/" + entry.getName());
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            targetFile.createNewFile();
            InputStream is = zipFile.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(targetFile);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.close();
            is.close();
        }
    }
}

