/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.apache.commons.lang.StringUtils;

public class UpdateSealUtil {
    public static BufferedImage addBusinessCodeToSealImage(BufferedImage image, String codeColor, String businessCode, String fontFamily, float fontSize, float ratioX, float ratioY) {
        int width = image.getWidth();
        int height = image.getHeight();
        int size = (int)(fontSize * (float)width / 100.0f);
        width = (int)(ratioX * (float)width);
        height = (int)(ratioY * (float)height);
        Graphics2D g2 = image.createGraphics();
        if (StringUtils.isNotBlank((String)codeColor)) {
            g2.setColor(Color.decode(codeColor));
        } else {
            g2.setColor(Color.decode("#FF3030"));
        }
        g2.setFont(new Font(StringUtil.isEmpty(fontFamily) ? "\u5b8b\u4f53" : fontFamily, 1, size));
        if (StringUtil.isNotEmpty(businessCode)) {
            g2.drawString(businessCode, width, height);
        }
        g2.dispose();
        return image;
    }

    public static BufferedImage addBusinessCodeToSealImage(BufferedImage image, String businessCode, String fontFamily, float fontSize, float ratioX, float ratioY) {
        int width = image.getWidth();
        int height = image.getHeight();
        int size = (int)(fontSize * (float)width / 100.0f);
        width = (int)(ratioX * (float)width);
        height = (int)(ratioY * (float)height);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.decode("#FF3030"));
        g2.setFont(new Font(StringUtil.isEmpty(fontFamily) ? "\u5b8b\u4f53" : fontFamily, 1, size));
        if (StringUtil.isNotEmpty(businessCode)) {
            g2.drawString(businessCode, width, height);
        }
        g2.dispose();
        return image;
    }
}

