/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.maker.util.EndianUtil;
import cfca.seal.maker.util.WebSealUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SealExtracter {
    private String version;
    private PrivateKey priKey;
    private X509Cert cert;
    private byte[] imageData;
    private byte[] pkcs12Data;
    private byte[] hash;
    private String signerName;
    private String unitName;
    private String sealName;
    private String subjectName;
    private int keyType = 0;

    public SealExtracter(byte[] sealData, String sealPWD) throws PKIException, IOException {
        this.init(sealData, sealPWD);
    }

    private void init(byte[] sealData, String sealPWD) throws PKIException, IOException {
        byte[] versionData = new byte[4];
        System.arraycopy(sealData, 10, versionData, 0, 4);
        this.version = new String(versionData, "UTF-8");
        byte[] totalLenData = new byte[4];
        System.arraycopy(sealData, 14, totalLenData, 0, 4);
        int totalLen = EndianUtil.bytesToInt(totalLenData);
        byte[] pfxLenData = new byte[4];
        System.arraycopy(sealData, 18, pfxLenData, 0, 4);
        int pfxSize = EndianUtil.bytesToInt(pfxLenData);
        this.pkcs12Data = new byte[pfxSize];
        System.arraycopy(sealData, 22, this.pkcs12Data, 0, pfxSize);
        this.keyType = WebSealUtil.getKeyStoreType(this.pkcs12Data);
        if (this.keyType == 1) {
            this.priKey = KeyUtil.getPrivateKeyFromPFX((byte[])this.pkcs12Data, (String)sealPWD);
            this.cert = CertUtil.getCertFromPFX((byte[])this.pkcs12Data, (String)sealPWD);
            this.hash = new byte[20];
        } else if (this.keyType == 2) {
            this.priKey = KeyUtil.getPrivateKeyFromSM2((byte[])this.pkcs12Data, (String)sealPWD);
            this.cert = CertUtil.getCertFromSM2((byte[])this.pkcs12Data);
            this.hash = new byte[32];
        }
        this.subjectName = this.cert.getSubject();
        int usbKeyDataLen = totalLen - 4 - pfxSize;
        byte[] usbKeyData = new byte[usbKeyDataLen];
        System.arraycopy(sealData, 22 + pfxSize, usbKeyData, 0, usbKeyDataLen);
        byte[] picLenData = new byte[4];
        System.arraycopy(usbKeyData, 4, picLenData, 0, 4);
        int picLen = EndianUtil.bytesToInt(picLenData);
        this.imageData = new byte[picLen];
        System.arraycopy(usbKeyData, 8, this.imageData, 0, picLen);
        byte[] signerLenData = new byte[4];
        System.arraycopy(usbKeyData, 8 + picLen, signerLenData, 0, 4);
        int signerLen = EndianUtil.bytesToInt(signerLenData);
        byte[] signerData = new byte[signerLen];
        System.arraycopy(usbKeyData, 8 + picLen + 4, signerData, 0, signerLen);
        this.signerName = new String(signerData, "UTF-8");
        byte[] unitDataLen = new byte[4];
        System.arraycopy(usbKeyData, 8 + picLen + 4 + signerLen, unitDataLen, 0, 4);
        int unitLen = EndianUtil.bytesToInt(unitDataLen);
        byte[] unitData = new byte[unitLen];
        System.arraycopy(usbKeyData, 8 + picLen + 4 + signerLen + 4, unitData, 0, unitLen);
        this.unitName = new String(unitData, "UTF-8");
        byte[] sealNameDataLen = new byte[4];
        System.arraycopy(usbKeyData, 8 + picLen + 4 + signerLen + 4 + unitLen, sealNameDataLen, 0, 4);
        int sealNameLen = EndianUtil.bytesToInt(sealNameDataLen);
        byte[] sealNameData = new byte[sealNameLen];
        System.arraycopy(usbKeyData, 8 + picLen + 4 + signerLen + 4 + unitLen + 4, sealNameData, 0, sealNameLen);
        this.sealName = new String(sealNameData, "UTF-8");
        System.arraycopy(sealData, 22 + pfxSize + usbKeyDataLen, this.hash, 0, this.hash.length);
    }

    public SealExtracter(String sealPath, String sealPWD) throws PKIException {
        try {
            byte[] sealData = FileUtils.readFileToByteArray((File)new File(sealPath));
            this.init(sealData, sealPWD);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
    }

    public int getKeyType() {
        return this.keyType;
    }

    public SealExtracter(InputStream is, String sealPWD) throws PKIException {
        try {
            byte[] sealData = IOUtils.toByteArray((InputStream)is);
            this.init(sealData, sealPWD);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getSealName() {
        return this.sealName;
    }

    public PrivateKey getPrivateKey() {
        return this.priKey;
    }

    public X509Cert getX509Cert() {
        return this.cert;
    }

    public String getSubject() {
        return this.subjectName;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getPic() {
        return this.imageData;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public byte[] getPfxData() {
        return this.pkcs12Data;
    }

    public byte[] getPKCS12Data() {
        return this.pkcs12Data;
    }
}

