/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.html;

import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.text.List;
import cfca.com.itextpdf.text.ListItem;
import cfca.com.itextpdf.tool.xml.NoCustomContextException;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.css.CssUtils;
import cfca.com.itextpdf.tool.xml.css.FontSizeTranslator;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;
import cfca.com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import cfca.com.itextpdf.tool.xml.html.AbstractTagProcessor;
import cfca.com.itextpdf.tool.xml.html.CssAppliers;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedUnorderedList
extends AbstractTagProcessor {
    private static final FontSizeTranslator fst = FontSizeTranslator.getInstance();
    private static final CssUtils utils = CssUtils.getInstance();

    @Override
    public java.util.List<Element> end(WorkerContext ctx, Tag tag, java.util.List<Element> currentContent) {
        java.util.List<Element> listElements = this.populateList(currentContent);
        int size = listElements.size();
        ArrayList<Element> returnedList = new ArrayList<Element>();
        if (size > 0) {
            List list;
            block13: {
                HtmlPipelineContext htmlPipelineContext = null;
                list = null;
                try {
                    htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                    CssAppliers cssAppliers = this.getCssAppliers();
                    if (null != cssAppliers && null != tag) {
                        list = (List)cssAppliers.apply(new List(), tag, htmlPipelineContext);
                    }
                }
                catch (NoCustomContextException e) {
                    CssAppliers cssAppliers = this.getCssAppliers();
                    if (null == cssAppliers || null == tag) break block13;
                    list = (List)cssAppliers.apply(new List(), tag, null);
                }
            }
            int i = 0;
            for (Element li : listElements) {
                if (li instanceof ListItem) {
                    float marginBottom;
                    Tag child = tag.getChildren().get(i);
                    if (size == 1) {
                        child.getCSS().put("margin-top", this.calculateTopOrBottomSpacing(true, false, tag, child, ctx) + "pt");
                        marginBottom = this.calculateTopOrBottomSpacing(false, false, tag, child, ctx);
                        child.getCSS().put("margin-bottom", marginBottom + "pt");
                    } else {
                        if (i == 0) {
                            child.getCSS().put("margin-top", this.calculateTopOrBottomSpacing(true, false, tag, child, ctx) + "pt");
                        }
                        if (i == size - 1) {
                            marginBottom = this.calculateTopOrBottomSpacing(false, true, tag, child, ctx);
                            child.getCSS().put("margin-bottom", marginBottom + "pt");
                        }
                    }
                    try {
                        list.add(this.getCssAppliers().apply(li, child, this.getHtmlPipelineContext(ctx)));
                    }
                    catch (NoCustomContextException e1) {
                        throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                    }
                } else {
                    list.add(li);
                }
                ++i;
            }
            returnedList.add(list);
        }
        return returnedList;
    }

    private java.util.List<Element> populateList(java.util.List<Element> currentContent) {
        ArrayList<Element> listElements = new ArrayList<Element>();
        for (Element e : currentContent) {
            if (e instanceof ListItem || e instanceof List) {
                listElements.add(e);
                continue;
            }
            ListItem listItem = new ListItem();
            listItem.add(e);
            listElements.add(listItem);
        }
        return listElements;
    }

    private float calculateTopOrBottomSpacing(boolean isTop, boolean storeMarginBottom, Tag tag, Tag child, WorkerContext ctx) {
        float totalSpacing = 0.0f;
        try {
            float childMargin;
            HtmlPipelineContext context = this.getHtmlPipelineContext(ctx);
            String end = isTop ? "-top" : "-bottom";
            float ownFontSize = fst.getFontSize(tag);
            float ownMargin = 0.0f;
            String marginValue = tag.getCSS().get("margin" + end);
            if (marginValue == null) {
                if (null != tag.getParent() && this.getHtmlPipelineContext(ctx).getRootTags().contains(tag.getParent().getName())) {
                    ownMargin = ownFontSize;
                }
            } else {
                ownMargin = utils.parseValueToPt(marginValue, ownFontSize);
            }
            float ownPadding = tag.getCSS().get("padding" + end) != null ? utils.parseValueToPt(tag.getCSS().get("padding" + end), ownFontSize) : 0.0f;
            float childFontSize = fst.getFontSize(child);
            float f = childMargin = child.getCSS().get("margin" + end) != null ? utils.parseValueToPt(child.getCSS().get("margin" + end), childFontSize) : 0.0f;
            if (ownPadding == 0.0f) {
                float margin = 0.0f;
                if (ownMargin != 0.0f && childMargin != 0.0f) {
                    margin = ownMargin >= childMargin ? ownMargin : childMargin;
                } else if (ownMargin != 0.0f) {
                    margin = ownMargin;
                } else if (childMargin != 0.0f) {
                    margin = childMargin;
                }
                if (!isTop && storeMarginBottom) {
                    context.getMemory().put("lastMarginBottom", Float.valueOf(margin));
                }
                totalSpacing = margin;
            } else {
                totalSpacing = ownMargin + ownPadding + childMargin;
                if (!isTop && storeMarginBottom) {
                    context.getMemory().put("lastMarginBottom", Float.valueOf(ownMargin));
                }
            }
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
        return totalSpacing;
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

