/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.crypto.DSA;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.NullDigest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.crypto.signers.SM2DSASigner;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.DSABase;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.DSAEncoder;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class SignatureSpi
extends DSABase {
    SignatureSpi(Digest digest, DSA signer, DSAEncoder encoder) {
        super("SM2DSA", digest, signer, encoder);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        ECPoint Q = null;
        if (publicKey instanceof ECPublicKey) {
            param = ECUtil.generatePublicKeyParameter(publicKey);
            Q = ((ECPublicKey)publicKey).getQ();
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in SM2DSA based signer");
                }
                param = ECUtil.generatePublicKeyParameter(publicKey);
                Q = ((ECPublicKey)publicKey).getQ();
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in SM2DSA based signer");
            }
        }
        this.signer.init(false, param);
        this.digest.reset();
        if (!(this.digest instanceof NullDigest)) {
            byte[] Z = SM2Params.calcZ(Q);
            this.digest.update(Z, 0, Z.length);
        }
    }

    protected void doEngineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        ECPoint Q;
        AsymmetricKeyParameter param;
        if (privateKey instanceof BCECPrivateKey) {
            param = ECUtil.generatePrivateKeyParameter(privateKey);
            Q = ((BCECPrivateKey)privateKey).getQ();
        } else if (privateKey instanceof GMTPrivateKey) {
            param = ECUtil.generatePrivateKeyParameter(privateKey);
            Q = ((GMTPrivateKey)privateKey).getSM2PublicKey().getQ();
        } else {
            throw new InvalidKeyException("can't recognise key type in SM2DSA based signer");
        }
        if (random != null) {
            this.signer.init(true, new ParametersWithRandom(param, random));
        } else {
            this.signer.init(true, param);
        }
        this.digest.reset();
        if (!(this.digest instanceof NullDigest)) {
            byte[] Z = SM2Params.calcZ(Q);
            this.digest.update(Z, 0, Z.length);
        }
    }

    private static class SM2DSAEncoder
    implements DSAEncoder {
        private final int length;

        public SM2DSAEncoder(int length) {
            this.length = length;
        }

        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(r));
            v.add(new ASN1Integer(s));
            return new DERSequence(v).getEncoded("DER");
        }

        public BigInteger[] decode(byte[] encoding) throws IOException {
            BigInteger[] sig = new BigInteger[2];
            if (encoding.length == this.length * 2) {
                sig[0] = BigIntegers.fromUnsignedByteArray(encoding, 0, this.length);
                sig[1] = BigIntegers.fromUnsignedByteArray(encoding, this.length, this.length);
                return sig;
            }
            ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
            sig[0] = ((ASN1Integer)s.getObjectAt(0)).getPositiveValue();
            sig[1] = ((ASN1Integer)s.getObjectAt(1)).getPositiveValue();
            return sig;
        }
    }

    public static class SM2DSAnone
    extends SignatureSpi {
        public SM2DSAnone() {
            super(new NullDigest(), new SM2DSASigner(), new SM2DSAEncoder(32));
        }
    }

    public static class SM2DSA
    extends SignatureSpi {
        public SM2DSA() {
            super(new SM3Digest(), new SM2DSASigner(), new SM2DSAEncoder(32));
        }
    }
}

