/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import cfca.sadk.com.itextpdf.svg.utils.SvgCssUtils;
import cfca.sadk.com.itextpdf.svg.utils.SvgTextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextSvgBranchRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    protected static final AffineTransform TEXTFLIP = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private final List<ISvgTextNodeRenderer> children = new ArrayList<ISvgTextNodeRenderer>();
    protected boolean performRootTransformations = true;
    private PdfFont font;
    private float fontSize;
    private boolean moveResolved = false;
    private float xMove;
    private float yMove;
    private boolean posResolved = false;
    private float[] xPos;
    private float[] yPos;
    private boolean whiteSpaceProcessed = false;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextSvgBranchRenderer copy = new TextSvgBranchRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    public final void addChild(ISvgTextNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public final List<ISvgTextNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        return 0.0f;
    }

    @Override
    public float[] getRelativeTranslation() {
        if (!this.moveResolved) {
            this.resolveTextMove();
        }
        return new float[]{this.xMove, this.yMove};
    }

    @Override
    public boolean containsRelativeMove() {
        if (!this.moveResolved) {
            this.resolveTextMove();
        }
        boolean isNullMove = CssUtils.compareFloats(0.0f, this.xMove) && CssUtils.compareFloats(0.0f, this.yMove);
        return !isNullMove;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        if (!this.posResolved) {
            this.resolveTextPosition();
        }
        return this.xPos != null && this.xPos.length > 0 || this.yPos != null && this.yPos.length > 0;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        if (!this.posResolved) {
            this.resolveTextPosition();
        }
        return new float[][]{this.xPos, this.yPos};
    }

    public void markWhiteSpaceProcessed() {
        this.whiteSpaceProcessed = true;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.performRootTransformations) {
                currentCanvas.beginText();
                AffineTransform rootTf = this.containsAbsolutePositionChange() ? TextSvgBranchRenderer.getTextTransform(this.getAbsolutePositionChanges(), context) : new AffineTransform(TEXTFLIP);
                currentCanvas.setTextMatrix(rootTf);
                context.resetTextMove();
                if (this.containsRelativeMove()) {
                    float[] rootMove = this.getRelativeTranslation();
                    context.addTextMove(rootMove[0], -rootMove[1]);
                }
                if (!this.whiteSpaceProcessed) {
                    SvgTextUtil.processWhiteSpace(this, true);
                }
            }
            this.applyTextRenderingMode(currentCanvas);
            if (this.attributesAndStyles != null) {
                this.resolveFontSize();
                for (ISvgTextNodeRenderer c : this.children) {
                    float textAnchorCorrection;
                    float childLength = c.getTextContentLength(this.fontSize, this.font);
                    if (c.containsAbsolutePositionChange()) {
                        float[][] absolutePositions = c.getAbsolutePositionChanges();
                        AffineTransform newTransform = TextSvgBranchRenderer.getTextTransform(absolutePositions, context);
                        context.setLastTextTransform(newTransform);
                        currentCanvas.setTextMatrix(newTransform);
                        context.resetTextMove();
                    }
                    if (!CssUtils.compareFloats(0.0f, textAnchorCorrection = this.getTextAnchorAlignmentCorrection(childLength))) {
                        context.addTextMove(textAnchorCorrection, 0.0f);
                    }
                    if (c.containsRelativeMove()) {
                        float[] childMove = c.getRelativeTranslation();
                        context.addTextMove(childMove[0], -childMove[1]);
                    }
                    currentCanvas.saveState();
                    c.draw(context);
                    context.addTextMove(childLength, 0.0f);
                    currentCanvas.restoreState();
                    if (context.getLastTextTransform().isIdentity()) continue;
                    currentCanvas.setTextMatrix(context.getLastTextTransform());
                }
                if (this.performRootTransformations) {
                    currentCanvas.endText();
                }
            }
        }
    }

    private void resolveTextMove() {
        if (this.attributesAndStyles != null) {
            String xRawValue = (String)this.attributesAndStyles.get("dx");
            String yRawValue = (String)this.attributesAndStyles.get("dy");
            List<String> xValuesList = SvgCssUtils.splitValueList(xRawValue);
            List<String> yValuesList = SvgCssUtils.splitValueList(yRawValue);
            this.xMove = 0.0f;
            this.yMove = 0.0f;
            if (!xValuesList.isEmpty()) {
                this.xMove = CssUtils.parseAbsoluteLength(xValuesList.get(0));
            }
            if (!yValuesList.isEmpty()) {
                this.yMove = CssUtils.parseAbsoluteLength(yValuesList.get(0));
            }
            this.moveResolved = true;
        }
    }

    private void resolveFontSize() {
        this.fontSize = SvgTextUtil.resolveFontSize(this, 12.0f);
    }

    private void resolveTextPosition() {
        if (this.attributesAndStyles != null) {
            String xRawValue = (String)this.attributesAndStyles.get("x");
            String yRawValue = (String)this.attributesAndStyles.get("y");
            this.xPos = TextSvgBranchRenderer.getPositionsFromString(xRawValue);
            this.yPos = TextSvgBranchRenderer.getPositionsFromString(yRawValue);
            this.posResolved = true;
        }
    }

    private static float[] getPositionsFromString(String rawValuesString) {
        float[] result = null;
        List<String> valuesList = SvgCssUtils.splitValueList(rawValuesString);
        if (!valuesList.isEmpty()) {
            result = new float[valuesList.size()];
            for (int i = 0; i < valuesList.size(); ++i) {
                result[i] = CssUtils.parseAbsoluteLength(valuesList.get(i));
            }
        }
        return result;
    }

    private static AffineTransform getTextTransform(float[][] absolutePositions, SvgDrawContext context) {
        AffineTransform tf = new AffineTransform();
        if (absolutePositions[0] == null && absolutePositions[1] != null) {
            absolutePositions[0] = new float[]{context.getTextMove()[0]};
        }
        if (absolutePositions[1] == null) {
            absolutePositions[1] = new float[]{0.0f};
        }
        tf.concatenate(TEXTFLIP);
        tf.concatenate(AffineTransform.getTranslateInstance(absolutePositions[0][0], -absolutePositions[1][0]));
        return tf;
    }

    private void applyTextRenderingMode(PdfCanvas currentCanvas) {
        if (this.doStroke && this.doFill) {
            currentCanvas.setTextRenderingMode(2);
        } else if (this.doStroke) {
            currentCanvas.setTextRenderingMode(1);
        } else {
            currentCanvas.setTextRenderingMode(0);
        }
    }

    private void deepCopyChildren(TextSvgBranchRenderer deepCopy) {
        for (ISvgTextNodeRenderer child : this.children) {
            ISvgTextNodeRenderer newChild = (ISvgTextNodeRenderer)child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    private float getTextAnchorAlignmentCorrection(float childContentLength) {
        float textAnchorXCorrection = 0.0f;
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text-anchor")) {
            String textAnchorValue = this.getAttribute("text-anchor");
            if (textAnchorValue.equals("middle") && this.xPos != null && this.xPos.length > 0) {
                textAnchorXCorrection -= childContentLength / 2.0f;
            }
            if (textAnchorValue.equals("end") && this.xPos != null && this.xPos.length > 0) {
                textAnchorXCorrection -= childContentLength;
            }
        }
        return textAnchorXCorrection;
    }
}

