/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.x509.certificate.CRLFindResult;
import cfca.sadk.x509.certificate.CRLLengths;
import cfca.sadk.x509.certificate.CRLRecord;
import cfca.sadk.x509.certificate.CRLStructure;
import cfca.sadk.x509.certificate.X509CRLBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.HashSet;

public final class X509CRLFile
extends X509CRLBase {
    static final int MAX_CRLFILE_SIZE = 0x64000000;
    static final int BUFFER_SIZE = 65536;
    final File crlFile;
    boolean cachesFinished = false;
    final HashSet caches = new HashSet();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509CRLFile(String crlFilePath, boolean enableCacheCRL) throws PKIException {
        if (crlFilePath == null) {
            throw new PKIException("Required parameter crlFilePath");
        }
        this.hashValue = null;
        this.crlFile = new File(crlFilePath);
        if (!this.crlFile.exists()) {
            throw new PKIException("Required parameter crlFilePath -->" + this.crlFile);
        }
        RandomAccessFile randomFile = null;
        try {
            try {
                randomFile = new RandomAccessFile(this.crlFile, "r");
                long fileLength = randomFile.length();
                if (fileLength > 0x64000000L) {
                    throw new PKIException("CrlFile verify failure with file too large --> " + fileLength);
                }
                int minLength = 80;
                if (randomFile.length() < 80L) {
                    throw new PKIException("CrlFile too small(fileLength<80) --> " + randomFile);
                }
                byte[] buffer = new byte[80];
                int remain = buffer.length;
                int offset = 0;
                int length = 0;
                while ((length = randomFile.read(buffer, offset, buffer.length - offset)) > 0 && (offset += length) != buffer.length && (remain -= length) > 0) {
                }
                CRLLengths crlLentgs = CRLLengths.buildLengthsFrom(buffer, 0, 48);
                if ((long)crlLentgs.asn1Length != fileLength) {
                    throw new PKIException("CrlFile verify failure when invalid asn1Length --> " + crlLentgs.asn1Length);
                }
                int position = crlLentgs.headLength;
                this.crlStructure = new CRLStructure(randomFile, position, fileLength, null);
                if (enableCacheCRL) {
                    this.cachesFinished = this.loadAllRecordsToMemory();
                }
            }
            catch (FileNotFoundException e) {
                throw new PKIException("CrlFile verify failure with file not exists --> " + this.crlFile, e);
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure --> " + this.crlFile, e);
            }
            catch (Throwable e) {
                throw new PKIException("CrlFile verify failure --> " + this.crlFile + ": " + e.getMessage());
            }
            Object var14_16 = null;
            if (randomFile == null) return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (randomFile == null) throw throwable;
            try {
                randomFile.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure when calc hashValue", e);
            }
        }
        try {}
        catch (Exception e) {
            throw new PKIException("CrlFile verify failure when calc hashValue", e);
        }
        randomFile.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRevoke(BigInteger serialNumber) throws PKIException {
        if (serialNumber == null) return false;
        if (this.crlStructure.isNoneCertTag()) {
            return false;
        }
        if (this.cachesFinished) {
            return this.caches.contains(new CRLRecord(serialNumber.toByteArray()));
        }
        byte[] certsn = serialNumber.toByteArray();
        boolean isRevoke = false;
        RandomAccessFile randomFile = null;
        try {
            try {
                randomFile = new RandomAccessFile(this.crlFile, "r");
                byte[] encoding = null;
                int position = this.crlStructure.context.certsTag.begin;
                CRLLengths lengths = null;
                CRLFindResult findResults = null;
                int expectLength = 65536;
                int offset = 0;
                for (int remain = this.crlStructure.context.certsTag.length; remain > 0 && !isRevoke; remain -= findResults.offset, position += findResults.offset) {
                    if (remain < expectLength) {
                        expectLength = remain;
                    }
                    encoding = this.crlStructure.valueFrom(randomFile, position, expectLength, null);
                    offset = 0;
                    if (position == this.crlStructure.context.certsTag.begin) {
                        lengths = CRLLengths.buildLengthsFrom(encoding, 0, 0);
                        offset += lengths.headLength;
                    }
                    findResults = CRLFindResult.findBlock(encoding, offset, encoding.length, certsn);
                    isRevoke = findResults.isRevoke;
                }
                Object var13_13 = null;
                if (randomFile == null) return isRevoke;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure with file too large --> " + this.crlFile, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (randomFile == null) throw throwable;
            try {
                randomFile.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure when calc hashValue", e);
            }
        }
        try {}
        catch (Exception e) {
            throw new PKIException("CrlFile verify failure when calc hashValue", e);
        }
        randomFile.close();
        return isRevoke;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadAllRecordsToMemory() throws PKIException {
        boolean success = false;
        if (this.cachesFinished) return success;
        if (this.crlStructure.isNoneCertTag()) return success;
        RandomAccessFile randomFile = null;
        try {
            try {
                randomFile = new RandomAccessFile(this.crlFile, "r");
                byte[] encoding = null;
                int position = this.crlStructure.context.certsTag.begin;
                int expectLength = 65536;
                int offset = 0;
                CRLLengths lengths = null;
                for (int remain = this.crlStructure.context.certsTag.length; remain > 0; remain -= offset, position += offset) {
                    if (remain < expectLength) {
                        expectLength = remain;
                    }
                    encoding = this.crlStructure.valueFrom(randomFile, position, expectLength, null);
                    offset = 0;
                    if (position == this.crlStructure.context.certsTag.begin) {
                        lengths = CRLLengths.buildLengthsFrom(encoding, 0, 0);
                        offset += lengths.headLength;
                    }
                    offset = CRLFindResult.loadBlock(encoding, offset, encoding.length, this.caches);
                }
                success = true;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure with file too large --> " + this.crlFile, e);
            }
            Object var10_10 = null;
            if (success) {
                this.cachesFinished = true;
            } else {
                this.caches.clear();
            }
            if (randomFile == null) return success;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (success) {
                this.cachesFinished = true;
            } else {
                this.caches.clear();
            }
            if (randomFile == null) throw throwable;
            try {
                randomFile.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure when calc hashValue", e);
            }
        }
        try {}
        catch (Exception e) {
            throw new PKIException("CrlFile verify failure when calc hashValue", e);
        }
        randomFile.close();
        return success;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("X509CRLFile [");
        if (this.crlStructure != null) {
            this.crlStructure.dump(builder);
        }
        builder.append("]");
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] hash(Digest hashEngine) throws PKIException {
        byte[] hashValue = null;
        RandomAccessFile randomFile = null;
        try {
            try {
                int length;
                randomFile = new RandomAccessFile(this.crlFile, "r");
                randomFile.seek(this.crlStructure.contextTag.begin);
                byte[] buffer = new byte[65536];
                int remain = this.crlStructure.contextTag.length;
                int n = length = buffer.length < remain ? buffer.length : remain;
                while ((length = randomFile.read(buffer, 0, length)) > 0) {
                    hashEngine.update(buffer, 0, length);
                    if ((remain -= length) <= 0) break;
                    if (remain > buffer.length) {
                        length = buffer.length;
                        continue;
                    }
                    length = remain;
                }
                hashValue = new byte[hashEngine.getDigestSize()];
                hashEngine.doFinal(hashValue, 0);
            }
            catch (IOException e) {
                throw new PKIException("CrlFile verify failure when calc hashValue", e);
            }
            Object var8_8 = null;
            if (randomFile == null) return hashValue;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (randomFile == null) throw throwable;
            try {
                randomFile.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure when calc hashValue", e);
            }
        }
        try {}
        catch (Exception e) {
            throw new PKIException("CrlFile verify failure when calc hashValue", e);
        }
        randomFile.close();
        return hashValue;
    }
}

