/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.javax.net.ssl;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCASSLParameters;
import cfca.sadk.tls.javax.net.ssl.CFCASSLTransfer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public abstract class CFCASSLSocket
extends SSLSocket
implements CFCASSLTransfer {
    protected CFCASSLSocket() {
    }

    protected CFCASSLSocket(String host, int port) throws IOException, UnknownHostException {
        super(host, port);
    }

    protected CFCASSLSocket(InetAddress address, int port) throws IOException {
        super(address, port);
    }

    protected CFCASSLSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
    }

    protected CFCASSLSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        super(address, port, clientAddress, clientPort);
    }

    @Override
    public abstract String[] getSupportedCipherSuites();

    @Override
    public abstract String[] getEnabledCipherSuites();

    @Override
    public abstract void setEnabledCipherSuites(String[] var1);

    @Override
    public abstract String[] getSupportedProtocols();

    @Override
    public abstract String[] getEnabledProtocols();

    @Override
    public abstract void setEnabledProtocols(String[] var1);

    @Override
    public abstract SSLSession getSession();

    @Override
    public SSLSession getHandshakeSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CFCASSLParameters getCFCASSLParameters() {
        CFCASSLParameters params = new CFCASSLParameters();
        params.setCipherSuites(this.getEnabledCipherSuites());
        params.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            params.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            params.setWantClientAuth(true);
        }
        return params;
    }

    @Override
    public void setCFCASSLParameters(CFCASSLParameters params) {
        String[] suits = null;
        suits = params.getCipherSuites();
        if (suits != null) {
            this.setEnabledCipherSuites(suits);
        }
        if ((suits = params.getProtocols()) != null) {
            this.setEnabledProtocols(suits);
        }
        if (params.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (params.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
    }

    @Override
    public final CFCAAlgorithmConstraints getAlgorithmConstraints() {
        return this.getCFCASSLParameters().getAlgorithmConstraints();
    }
}

