/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.util.Utilities;

public class Authenticator {
    private static final int BLOCK_SIZE_TLS = 13;
    private final byte[] block;

    protected Authenticator() {
        this.block = new byte[0];
    }

    protected Authenticator(ProtocolVersion protocolVersion) {
        this.block = new byte[13];
        this.block[9] = protocolVersion.major;
        this.block[10] = protocolVersion.minor;
    }

    final boolean seqNumOverflow() {
        return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1 && this.block[4] == -1 && this.block[5] == -1 && this.block[6] == -1;
    }

    final boolean seqNumIsHuge() {
        return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1;
    }

    final byte[] sequenceNumber() {
        return Utilities.copyOf(this.block, 8);
    }

    protected final byte[] acquireAuthenticationBytes(byte type, int length) {
        byte[] data = (byte[])this.block.clone();
        if (this.block.length != 0) {
            data[8] = type;
            data[data.length - 2] = (byte)(length >> 8);
            data[data.length - 1] = (byte)length;
            int k = 7;
            while (k >= 0) {
                int n = k--;
                this.block[n] = (byte)(this.block[n] + 1);
                if (this.block[n] == 0) continue;
            }
        }
        return data;
    }
}

