/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PropertiesUtil {
    public static Properties loadProperties(String proeprtiesFilePath) throws CodeException {
        Properties properties = new Properties();
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(proeprtiesFilePath);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            properties.load(inputStreamReader);
        }
        catch (Exception e) {
            try {
                throw new CodeException("600103", proeprtiesFilePath + ",\u8def\u5f84\u9519\u8bef", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                IOUtils.closeQuietly(inputStreamReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((Reader)inputStreamReader);
        return properties;
    }

    public static String readProperty(Properties properties, String propertyName, String ... defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if ((propertyValue == null || propertyValue.trim().length() == 0) && defaultValue != null && defaultValue.length > 0) {
            propertyValue = defaultValue[0];
        }
        return propertyValue;
    }

    public static String readNotNullProperty(Properties properties, String propertyName) throws IllegalArgumentException {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null || propertyValue.trim().length() == 0) {
            throw new IllegalArgumentException(propertyName + " can't be null");
        }
        return propertyValue;
    }

    public static int readIntProperty(Properties properties, String propertyName, int ... defaultValue) {
        String propertyValue;
        int result = 0;
        if (defaultValue != null && defaultValue.length > 0) {
            result = defaultValue[0];
        }
        if ((propertyValue = properties.getProperty(propertyName)) != null && propertyValue.trim().length() > 0) {
            result = Integer.parseInt(propertyValue.trim());
        }
        return result;
    }

    public static int readIntPropertyWithExpectedValue(Properties properties, String propertyName, int expectedValue, int defaultValue) {
        int propertiesValue = PropertiesUtil.readIntProperty(properties, propertyName, defaultValue);
        return propertiesValue == expectedValue ? expectedValue : defaultValue;
    }

    public static float readFloatProperty(Properties properties, String propertyName, float ... defaultValue) {
        String propertyValue;
        float result = 0.0f;
        if (defaultValue != null && defaultValue.length > 0) {
            result = defaultValue[0];
        }
        if ((propertyValue = properties.getProperty(propertyName)) != null && propertyValue.trim().length() > 0) {
            result = Float.parseFloat(propertyValue.trim());
        }
        return result;
    }

    public static boolean readBooleanProperty(Properties properties, String propertyName, boolean ... defaultValue) {
        String propertyValue;
        boolean result = false;
        if (defaultValue != null && defaultValue.length > 0) {
            result = defaultValue[0];
        }
        if ((propertyValue = properties.getProperty(propertyName)) != null && propertyValue.trim().length() > 0) {
            result = Boolean.parseBoolean(propertyValue.trim());
        }
        return result;
    }
}

