/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FontInputStream
extends FilterInputStream {
    private long position;
    private long length;
    private boolean bounded;

    public FontInputStream(InputStream is) {
        super(is);
    }

    public FontInputStream(InputStream is, int length) {
        this(is);
        this.length = length;
        this.bounded = true;
    }

    @Override
    public int read() throws IOException {
        if (this.bounded && this.position >= this.length) {
            return -1;
        }
        int b = super.read();
        if (b >= 0) {
            ++this.position;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bounded && this.position >= this.length) {
            return -1;
        }
        int bytesToRead = this.bounded ? (int)Math.min((long)len, this.length - this.position) : len;
        int bytesRead = super.read(b, off, bytesToRead);
        this.position += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long position() {
        return this.position;
    }

    public int readChar() throws IOException {
        return this.read();
    }

    public int readUShort() throws IOException {
        return 0xFFFF & (this.read() << 8 | this.read());
    }

    public int readShort() throws IOException {
        return (this.read() << 8 | this.read()) << 16 >> 16;
    }

    public int readUInt24() throws IOException {
        return 0xFFFFFF & (this.read() << 16 | this.read() << 8 | this.read());
    }

    public long readULong() throws IOException {
        return 0xFFFFFFFFL & (long)this.readLong();
    }

    public int readULongAsInt() throws IOException {
        long ulong = this.readULong();
        if ((ulong & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new ArithmeticException("Long value too large to fit into an integer.");
        }
        return (int)ulong & Integer.MAX_VALUE;
    }

    public int readLong() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public int readFixed() throws IOException {
        return this.readLong();
    }

    public long readDateTimeAsLong() throws IOException {
        return this.readULong() << 32 | this.readULong();
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.position += skipped;
        return skipped;
    }
}

