/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.conversion.eot;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import cfca.sadk.com.google.typography.font.tools.conversion.eot.MagnitudeDependentWriter;

public class HdmxEncoder {
    private static int HEADER_SIZE = 8;
    private static int RECORD_SIZE = 2;

    public WritableFontData encode(Font sourceFont) {
        HorizontalDeviceMetricsTable hdmx = (HorizontalDeviceMetricsTable)sourceFont.getTable(Tag.hdmx);
        HorizontalMetricsTable hmtx = (HorizontalMetricsTable)sourceFont.getTable(Tag.hmtx);
        MaximumProfileTable maxp = (MaximumProfileTable)sourceFont.getTable(Tag.maxp);
        FontHeaderTable head = (FontHeaderTable)sourceFont.getTable(Tag.head);
        int unitsPerEm = head.unitsPerEm();
        int numRecords = hdmx.numRecords();
        int numGlyphs = maxp.numGlyphs();
        MagnitudeDependentWriter magWriter = new MagnitudeDependentWriter();
        for (int i = 0; i < numRecords; ++i) {
            int ppem = hdmx.pixelSize(i);
            for (int j = 0; j < numGlyphs; ++j) {
                int roundedTtAw = ((64 * ppem * hmtx.advanceWidth(j) + unitsPerEm / 2) / unitsPerEm + 32) / 64;
                int surprise = hdmx.width(i, j) - roundedTtAw;
                magWriter.writeValue(surprise);
            }
        }
        magWriter.flush();
        byte[] magBytes = magWriter.toByteArray();
        int resultSize = magBytes.length + HEADER_SIZE + RECORD_SIZE * numRecords;
        WritableFontData result = WritableFontData.createWritableFontData(resultSize);
        result.writeUShort(0, 0);
        result.writeUShort(2, numRecords);
        result.writeLong(4, hdmx.recordSize());
        for (int i = 0; i < numRecords; ++i) {
            result.writeByte(HEADER_SIZE + RECORD_SIZE * i, (byte)hdmx.pixelSize(i));
            result.writeByte(HEADER_SIZE + RECORD_SIZE * i + 1, (byte)hdmx.maxWidth(i));
        }
        result.writeBytes(HEADER_SIZE + RECORD_SIZE * numRecords, magBytes);
        return result;
    }
}

