/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.util;

import cfca.sadk.com.itextpdf.io.IOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterUtil.class);

    private FilterUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] flateDecode(byte[] input, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(input);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                output.write(b, 0, n);
            }
            zip.close();
            output.close();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = strict ? null : output.toByteArray();
            return byArray;
        }
        finally {
            try {
                zip.close();
                output.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static byte[] flateDecode(byte[] input) {
        byte[] b = FilterUtil.flateDecode(input, true);
        if (b == null) {
            return FilterUtil.flateDecode(input, false);
        }
        return b;
    }

    public static void inflateData(byte[] deflated, byte[] inflated) {
        Inflater inflater = new Inflater();
        inflater.setInput(deflated);
        try {
            inflater.inflate(inflated);
        }
        catch (DataFormatException dfe) {
            throw new IOException("Cannot inflate TIFF image.");
        }
    }

    public static InputStream getInflaterInputStream(InputStream input) {
        return new InflaterInputStream(input, new Inflater());
    }
}

