/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.collection;

import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import java.util.Arrays;

public class PdfCollectionSort
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -3871923275239410475L;

    public PdfCollectionSort(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfCollectionSort(String key) {
        this(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, new PdfName(key));
    }

    public PdfCollectionSort(String[] keys) {
        this(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, new PdfArray(Arrays.asList(keys), true));
    }

    public PdfCollectionSort setSortOrder(boolean ascending) {
        PdfObject obj = ((PdfDictionary)this.getPdfObject()).get(PdfName.S);
        if (!obj.isName()) {
            throw new PdfException("You have to define a boolean array for this collection sort dictionary.");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.A, PdfBoolean.valueOf(ascending));
        return this;
    }

    public PdfCollectionSort setSortOrder(boolean[] ascending) {
        PdfObject obj = ((PdfDictionary)this.getPdfObject()).get(PdfName.S);
        if (obj.isArray()) {
            if (((PdfArray)obj).size() != ascending.length) {
                throw new PdfException("The number of booleans in the array doesn't correspond with the number of fields.");
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.A, new PdfArray(ascending));
            return this;
        }
        throw new PdfException("You need a single boolean for this collection sort dictionary.");
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

