/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzY6r;
    private DataTable zzY6q;
    private DataTable zzY6p;
    private String zzgX;
    private String zzgW;
    private String[] zzY6o;
    private String[] zzY6n;
    private DataColumn[] zzY6m;
    private DataColumn[] zzY6l;
    private boolean zzY6k;
    private UniqueConstraint zzY6j;
    private ForeignKeyConstraint zzY6i;
    private boolean zzY6h = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzY6r = relationName;
        this.zzY6q = parentTable;
        this.zzY6p = childTable;
        this.zzgX = parentTable.getTableName();
        this.zzgW = childTable.getTableName();
        this.zzY6o = parentColumnNames;
        this.zzY6n = childColumnNames;
        this.zzY6m = new DataColumn[this.zzY6o.length];
        for (n = 0; n < this.zzY6o.length; ++n) {
            this.zzY6m[n] = new DataColumn(this.zzY6o[n], this.zzY6q);
        }
        this.zzY6l = new DataColumn[this.zzY6n.length];
        for (n = 0; n < this.zzY6n.length; ++n) {
            this.zzY6l[n] = new DataColumn(this.zzY6n[n], this.zzY6p);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        String string = this.zzY6r = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzY6m = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzY6l = childColumns;
        this.zzY6h = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        for (DataColumn dataColumn : parentColumns) {
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        for (DataColumn dataColumn : childColumns) {
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzY6l.length; ++n) {
            if (parentColumns[n].zzY(childColumns[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzY6o = new String[this.zzY6m.length];
        for (n = 0; n < this.zzY6m.length; ++n) {
            this.zzY6o[n] = this.zzY6m[n].getColumnName();
        }
        this.zzY6n = new String[this.zzY6l.length];
        for (n = 0; n < this.zzY6l.length; ++n) {
            this.zzY6n[n] = this.zzY6l[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzY6r;
    }

    public String getParentTableName() {
        return this.zzgX;
    }

    public String getChildTableName() {
        return this.zzgW;
    }

    public DataTable getParentTable() {
        return this.zzY6q != null ? this.zzY6q : this.zzY6m[0].getTable();
    }

    public DataTable getChildTable() {
        return this.zzY6p != null ? this.zzY6p : this.zzY6l[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzY6o;
    }

    public String[] getChildColumnNames() {
        return this.zzY6n;
    }

    public DataColumn[] getParentColumns() {
        return this.zzY6m;
    }

    public DataColumn[] getChildColumns() {
        return this.zzY6l;
    }

    public void setNested(boolean nested) {
        this.zzY6k = nested;
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzY6j;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzY6j = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzY6i;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzY6i = childKeyConstraint;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.zzY6r.hashCode();
        n = n * 31 + this.zzgX.hashCode();
        n = n * 31 + this.zzgW.hashCode();
        for (int i = 0; i < this.zzY6o.length; ++i) {
            n = n * 31 + this.zzY6o[i].hashCode();
            n = n * 31 + this.zzY6n[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl2 = bl = this.zzY6r.equals(dataRelation.getRelationName()) && this.zzgX.equals(dataRelation.getParentTableName()) && this.zzgW.equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.zzY6o.length != dataRelation.getParentColumnNames().length || this.zzY6n.length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.zzY6o.length; ++i) {
            if (this.zzY6o[i].equals(dataRelation.getParentColumnNames()[i]) && this.zzY6n[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    void zzYWp() throws InvalidConstraintException, DataException {
        if (!this.zzY6h) {
            return;
        }
        ForeignKeyConstraint foreignKeyConstraint = null;
        UniqueConstraint uniqueConstraint = null;
        foreignKeyConstraint = this.zzX(this.getChildTable().getConstraints());
        uniqueConstraint = this.zzY(this.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzY(ConstraintCollection constraintCollection) {
        UniqueConstraint uniqueConstraint = null;
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            uniqueConstraint = (UniqueConstraint)constraint;
            if (!this.zzZ(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzX(ConstraintCollection constraintCollection) {
        ForeignKeyConstraint foreignKeyConstraint = null;
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!this.zzZ(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !this.zzZ(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

